package top.lingkang.finalsql.dialect;

import top.lingkang.finalsql.sql.ExSqlEntity;

import java.util.ArrayList;

/**
 * @author lingkang
 * Created by 2022/4/11
 * 方言接口，使用方言处理以适应不同数据库ORM操作
 * 接口默认使用MySQL协议的方言处理
 */
public interface SqlDialect {
    default String one(String sql) {
        return "select " + sql + " limit 1";
    }

    default String count(String sql) {
        return "select count(*) " + sql;
    }

    default String getTableName(String name) {
        return name;
    }

    String nextval(String column);

    /**
     * 分页获取行
     *
     * @param sql   类似添加mysql中的 limit
     * @param start 类似添加mysql中的 limit star,999
     * @param row   类似添加mysql中的 limit 0,row
     * @return
     */
    default String rowSql(String sql, int start, int row) {
        return sql + " limit " + start + "," + row;
    }

    /**
     * 用于分页统计
     */
    default ExSqlEntity total(ExSqlEntity sqlEntity) {
        ExSqlEntity entity = new ExSqlEntity(sqlEntity.getSql(), new ArrayList<>(sqlEntity.getParam()));
        String low = entity.getSql().toLowerCase();
        int from = findTag(low, "from", 0);
        String temp = entity.getSql().substring(0, from);
        int i1 = temp.indexOf("(");
        if (i1 != -1) {
            do {
                i1 = findTag(low, "select", i1);
                // 判断 ( 与 from 之间是否存在 select
                if (i1 != -1 && i1 < from) {
                    int tem = findTag(low, "from", from + 1);// 找下一个 from
                    if (tem != -1) {
                        from = tem;
                        // 再找下一个 (
                        i1 = low.indexOf("(", i1);
                    } else
                        break;
                } else
                    break;
            } while (true);
        }

        // 检查结果列中的查询, 例如：
        // select id,(select username from user where u.id=id and username=?) from user u order by id desc
        // 入参 ‘lingkang’
        temp = low.substring(0, from);
        if ((i1 = temp.indexOf("?")) != -1) {
            int has = 1;
            for (; ; ) {
                if ((i1 = temp.indexOf("?", i1 + 1)) != -1)
                    has++;
                else
                    break;
            }
            while (has != 0) {
                entity.getParam().remove(--has);
            }
        }

        // 检查排序
        i1 = low.indexOf("order");
        if (i1 != -1) {
            entity.setSql("select count(*) " + entity.getSql().substring(from, i1));
        } else {
            entity.setSql("select count(*) " + entity.getSql().substring(from));
        }
        return entity;
    }


    // 非方言处理 --------------------------------------------------------------------
    default int findTag(String low, String str, int fromIndex) {
        int indexOf = low.indexOf(str, fromIndex);
        if (indexOf == -1) {
            return -1;
        }

        if (check(low, str, indexOf))
            return indexOf;
        else
            return findTag(low, str, indexOf);
    }

    default boolean check(String low, String str, int index) {
        if (index != 0) {
            char c = low.charAt(index - 1);
            if (!isChar(c)) {
                return false;
            }
        }
        if (low.length() != (str.length() + index) && !isChar(low.charAt(index + str.length())))
            return false;
        return true;
    }

    default boolean isChar(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '(' || c == ')';
    }
}
