/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.spring;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import top.lingkang.finalsql.sql.FinalSql;

@Aspect
@Component
public class FinalSqlTransactionalManagement {
    private static final ThreadLocal<Integer> threadLocal = new ThreadLocal();
    @Autowired(required=false)
    private ApplicationContext context;

    @Around(value="@within(top.lingkang.finalsql.annotation.Transactional) || @annotation(top.lingkang.finalsql.annotation.Transactional)")
    public Object finalSqlTransactionalAop(ProceedingJoinPoint joinPoint) throws Throwable {
        List<FinalSql> finalSql = this.getFinalSql();
        try {
            if (finalSql.isEmpty()) {
                return joinPoint.proceed();
            }
            if (threadLocal.get() == null) {
                threadLocal.set(1);
                for (FinalSql sql : finalSql) {
                    sql.beginTransaction();
                }
            } else {
                threadLocal.set(threadLocal.get() + 1);
            }
            Object proceed = joinPoint.proceed();
            if (threadLocal.get() == 1) {
                for (FinalSql sql : finalSql) {
                    sql.commitTransaction();
                }
            } else {
                threadLocal.set(threadLocal.get() - 1);
            }
            return proceed;
        }
        catch (Exception e) {
            if (threadLocal.get() != null) {
                for (FinalSql sql : finalSql) {
                    sql.rollbackTransaction();
                }
            }
            throw e;
        }
    }

    private List<FinalSql> getFinalSql() {
        String[] names = this.context.getBeanNamesForType(FinalSql.class);
        ArrayList<FinalSql> list = new ArrayList<FinalSql>();
        for (String name : names) {
            list.add((FinalSql)this.context.getBean(name, FinalSql.class));
        }
        return list;
    }
}

