/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql;

import java.sql.Connection;
import top.lingkang.finalsql.base.SqlInterceptor;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.dialect.SqlDialect;
import top.lingkang.finalsql.error.FinalSqlException;
import top.lingkang.finalsql.sql.ExSqlEntity;
import top.lingkang.finalsql.sql.PageInfo;
import top.lingkang.finalsql.sql.core.FinalSqlManage;

public class FinalPageInterceptor
implements SqlInterceptor {
    private SqlConfig sqlConfig;
    private FinalSqlManage finalSqlManage;

    public FinalPageInterceptor(SqlConfig sqlConfig, FinalSqlManage finalSqlManage) {
        this.sqlConfig = sqlConfig;
        this.finalSqlManage = finalSqlManage;
    }

    @Override
    public void before(ExSqlEntity sqlEntity, Connection connection) {
        PageInfo pageInfo = (PageInfo)this.finalSqlManage.PAGE_INFO_THREAD_LOCAL.get();
        if (pageInfo != null && pageInfo.isStart()) {
            try {
                SqlDialect sqlDialect = this.sqlConfig.getSqlDialect();
                ExSqlEntity totalSql = sqlDialect.total(sqlEntity);
                pageInfo.setStart(false);
                Integer totals = this.finalSqlManage.selectForObject(totalSql.getSql(), Integer.class, totalSql.getParam());
                pageInfo.setTotal(totals);
                this.finalSqlManage.PAGE_INFO_THREAD_LOCAL.set(pageInfo);
                String s = sqlDialect.rowSql(sqlEntity.getSql(), (pageInfo.getPage() - 1) * pageInfo.getSize(), pageInfo.getSize());
                sqlEntity.setSql(s);
            }
            catch (Exception e) {
                throw new FinalSqlException("\u5206\u9875\u5904\u7406\u5f02\u5e38\uff1a", e);
            }
        }
    }

    @Override
    public void after(ExSqlEntity sqlEntity, Connection connection, Object result) {
    }
}

