/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.ui;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import top.lingkang.finalsql.sql.FinalSql;
import top.lingkang.finalsql.ui.GenerateBuild;
import top.lingkang.finalsql.ui.GenerateColumn;
import top.lingkang.finalsql.ui.GenerateProperties;
import top.lingkang.finalsql.ui.GenerateUtils;

public class GenerateBuildSqlite3
implements GenerateBuild {
    private final String sql_tables = "SELECT name FROM sqlite_master WHERE type ='table';";
    private final String sql_column = "Pragma Table_Info(%s)";

    @Override
    public void build(FinalSql finalSql, GenerateProperties properties) {
        GenerateUtils.checkGenerateProperties(properties);
        List<String> tables = finalSql.selectForList("SELECT name FROM sqlite_master WHERE type ='table';", String.class);
        if (tables.isEmpty()) {
            return;
        }
        String pageName = GenerateUtils.getPage(properties.getOutDir());
        String template = GenerateUtils.readFile(GenerateBuildSqlite3.class.getClassLoader().getResourceAsStream("java-template.txt"));
        if (!GenerateUtils.isBlank(pageName)) {
            pageName = "package " + pageName + ";";
        }
        template = template.replace("#package", pageName);
        String ignoreTablePrefix = properties.getIgnoreTablePrefix();
        HashSet<String> hasClassName = new HashSet<String>();
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        for (String table : tables) {
            String className = GenerateUtils.handlerTableName(table, ignoreTablePrefix);
            if (hasClassName.contains(className)) {
                className = GenerateUtils.hasSomeName(className, hasClassName);
            }
            hasClassName.add(className);
            String t = template;
            t = t.replace("#date", date);
            t = t.replace("#table", table);
            t = t.replace("#className", className);
            HashSet<String> impl = new HashSet<String>();
            List<Map> columns = finalSql.selectForList(String.format("Pragma Table_Info(%s)", table), Map.class);
            int keyNumber = 0;
            ArrayList<GenerateColumn> generateColumns = new ArrayList<GenerateColumn>();
            for (Map map : columns) {
                String column_name = map.get("name").toString();
                String data_type = map.get("type").toString();
                String column_key = map.get("pk").toString();
                GenerateColumn column = GenerateUtils.columnTypeToJavaType(column_name, data_type, "mysql");
                if (!GenerateUtils.isBlank(column_key) && Integer.parseInt(column_key) == 1) {
                    ++keyNumber;
                    column.setKey(true);
                }
                generateColumns.add(column);
                if (column.getImportName() == null) continue;
                impl.add(column.getImportName());
            }
            String imports = "";
            for (String im : impl) {
                imports = imports + im + "\n";
            }
            t = t.replace("#import", imports);
            String string = GenerateUtils.columnToString(generateColumns, keyNumber);
            t = t.replace("#entity", string);
            System.out.println(t);
            this.outFile(properties.getOutDir() + File.separator + className + ".java", t, properties.isCover());
        }
    }
}

