/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import top.lingkang.finalsql.ui.DbColumnTypeToJavaType;
import top.lingkang.finalsql.ui.DbToJava;
import top.lingkang.finalsql.ui.DefaultDbColumnTypeToJavaType;
import top.lingkang.finalsql.ui.GenerateColumn;
import top.lingkang.finalsql.ui.GenerateProperties;
import top.lingkang.finalsql.utils.NameUtils;

class GenerateUtils {
    public static DbColumnTypeToJavaType columnTypeToJavaType = new DefaultDbColumnTypeToJavaType();

    GenerateUtils() {
    }

    public static String getBasePath() {
        URL xmlpath = GenerateUtils.class.getResource("/");
        String path = xmlpath.getPath().substring(1);
        if (path.contains("/target/classes/")) {
            path = path.substring(0, path.indexOf("/target/classes/"));
        }
        return path;
    }

    public static String getPage(String path) {
        path = path.replaceAll("\\\\", ".");
        int index = (path = path.replaceAll("/", ".")).indexOf("main.java");
        if (index != -1) {
            return path.substring(index + 10);
        }
        index = path.indexOf("test.java");
        if (index != -1) {
            return path.substring(index + 10);
        }
        index = path.indexOf("src");
        if (index != -1) {
            return path.substring(index + 4);
        }
        return "";
    }

    public static String readFile(InputStream inputStream) {
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s + "\n";
            }
            inputStream.close();
            reader.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String fileRead(File file) {
        try {
            if (file.exists()) {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                BufferedReader bf = new BufferedReader(isr);
                StringBuilder res = new StringBuilder();
                String cc = null;
                while ((cc = bf.readLine()) != null) {
                    res.append(cc);
                }
                bf.close();
                isr.close();
                return res.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static List<String> fileReadByLine(File file) {
        try {
            if (file.exists()) {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                BufferedReader bf = new BufferedReader(isr);
                ArrayList<String> res = new ArrayList<String>();
                String cc = null;
                while ((cc = bf.readLine()) != null) {
                    res.add(cc);
                }
                bf.close();
                isr.close();
                return res;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static List<String> stringReadByLine(String str) {
        String[] split = str.split("\n");
        return new ArrayList<String>(Arrays.asList(split));
    }

    public static boolean isBlank(String str) {
        return str == null || str.length() == 0;
    }

    public static String handlerTableName(String name, String ignoreTablePrefix) {
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        if (!GenerateUtils.isBlank(ignoreTablePrefix)) {
            String[] split;
            for (String ig : split = ignoreTablePrefix.replace(" ", "").split(",")) {
                if (GenerateUtils.isBlank(ig) || !name.startsWith(ig)) continue;
                name = name.substring(ig.length());
                break;
            }
        }
        name = NameUtils.toHump(name);
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static GenerateColumn columnTypeToJavaType(String columnName, String columnType, String dbType) {
        GenerateColumn column = new GenerateColumn();
        columnType = columnType.toLowerCase();
        DbToJava match = columnTypeToJavaType.match(columnName, columnType, dbType);
        column.setType(match.getType());
        column.setImportName(match.getImportName());
        column.setName(NameUtils.toHump(columnName));
        column.setColumnName(columnName);
        return column;
    }

    public static String columnToString(List<GenerateColumn> columns, int keyNumber) {
        StringBuffer buffer = new StringBuffer();
        for (GenerateColumn column : columns) {
            if (!GenerateUtils.isBlank(column.getComment())) {
                buffer.append("    // " + column.getComment());
                buffer.append("\n");
            }
            if (keyNumber == 1 && column.isKey()) {
                buffer.append("    @Id");
            } else if (column.getName().equals(column.getColumnName())) {
                buffer.append("    @Column");
            } else {
                buffer.append("    @Column(\"" + column.getColumnName() + "\")");
            }
            buffer.append("\n");
            buffer.append("    private " + column.getType() + " " + column.getName() + ";");
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    public static void writeFile(File file, String content) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            out.write(content);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String hasSomeName(String name, HashSet<String> hasName) {
        if (hasName.contains(name)) {
            int index = name.lastIndexOf("_");
            if (index != -1 && index + 1 <= name.length()) {
                int i = Integer.parseInt(name.substring(index + 1));
                name = name.substring(0, index + 1) + ++i;
            } else {
                name = name + "_1";
            }
            return GenerateUtils.hasSomeName(name, hasName);
        }
        return name;
    }

    public static void checkGenerateProperties(GenerateProperties properties) {
        if (GenerateUtils.isBlank(properties.getOutDir())) {
            throw new RuntimeException("\u8f93\u51fa\u7684entity\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        System.out.println("\u8f93\u51fa\u7684\u5b9e\u4f53\u76ee\u5f55\uff1a" + properties.getOutDir());
    }
}

