/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.utils;

import java.util.Arrays;
import top.lingkang.finalsql.annotation.Table;
import top.lingkang.finalsql.dialect.SqlDialect;
import top.lingkang.finalsql.error.FinalCheckException;
import top.lingkang.finalsql.utils.CommonUtils;

public class NameUtils {
    public static hump hump = new DefaultHump();

    public static String toHump(String str) {
        return hump.to(str);
    }

    public static String unHump(String str) {
        return hump.un(str);
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static String getTableName(Class<?> clazz, SqlDialect dialect) {
        Table annotation = clazz.getAnnotation(Table.class);
        if (annotation == null) {
            throw new FinalCheckException("\u8868\u6620\u5c04\u7c7b\u65e0 @Table \u6ce8\u89e3");
        }
        if (CommonUtils.isNotEmpty(annotation.value())) {
            return dialect.getTableName(annotation.value());
        }
        return dialect.getTableName(NameUtils.unHump(clazz.getSimpleName()));
    }

    static class DefaultHump
    implements hump {
        DefaultHump() {
        }

        @Override
        public String to(String str) {
            char[] chars = str.toCharArray();
            if (NameUtils.isUpper(chars[0])) {
                chars[0] = (char)(chars[0] + 32);
            }
            int num = 0;
            for (int i = 1; i < chars.length; ++i) {
                if (chars[i] == '_') {
                    if (i + 1 < chars.length && NameUtils.isLower(chars[i + 1])) {
                        chars[i + 1] = (char)(chars[i + 1] - 32);
                    }
                    ++num;
                    continue;
                }
                chars[i - num] = chars[i];
            }
            return new String(Arrays.copyOf(chars, chars.length - num));
        }

        @Override
        public String un(String str) {
            char[] chars = str.toCharArray();
            char[] res = new char[chars.length * 2];
            res[0] = NameUtils.isUpper(chars[0]) ? (char)(chars[0] + 32) : chars[0];
            int num = 1;
            for (int i = 1; i < chars.length; ++i) {
                if (NameUtils.isUpper(chars[i])) {
                    res[num++] = 95;
                    res[num++] = (char)(chars[i] + 32);
                    continue;
                }
                res[num++] = chars[i];
            }
            return new String(Arrays.copyOf(res, num));
        }
    }

    static interface hump {
        public String to(String var1);

        public String un(String var1);
    }
}

