/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import top.lingkang.finalvalidated.core.CheckObject;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.handle.ValidHandle;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

public class FinalValidatorFactory
implements Validator {
    private static final Map<Class<?>, CheckObject> cache = new HashMap();
    public static final Properties message = new Properties();

    public boolean supports(Class<?> clazz) {
        CheckObject check = cache.get(clazz);
        if (check != null) {
            return check.isNeed();
        }
        check = new CheckObject();
        if (FinalValidatorUtils.existsConstraints(clazz.getDeclaredFields())) {
            check.setNeed(true);
            check.setHandles(this.initValidHandle(clazz));
        }
        cache.put(clazz, check);
        return check.isNeed();
    }

    public void validate(Object target, Errors errors) {
        CheckObject checkObject = cache.get(target.getClass());
        for (ValidHandle handle : checkObject.getHandles()) {
            handle.valid(target);
        }
    }

    private List<ValidHandle> initValidHandle(Class<?> clazz) {
        Field[] fields;
        ArrayList<ValidHandle> list = new ArrayList<ValidHandle>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!FinalValidatorUtils.annotationConstraints(annotation)) continue;
                try {
                    list.add(FinalValidatorUtils.annotationToValidHandle(field.getName(), annotation));
                }
                catch (CheckException e) {
                    throw new CheckException("\u6821\u9a8c\u5f02\u5e38\u5bf9\u8c61\uff1a" + clazz.getName(), e);
                }
            }
        }
        return list;
    }
}

