/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class PatternHandle
implements ValidHandle {
    private String name;
    private String errorStr;
    private Pattern pattern;

    public PatternHandle(String name, String message, String tag, String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            throw new CheckException("@Pattern \u6240\u914d\u7f6e\u7684\u6b63\u5219\u8868\u8fbe\u5f0f(value)\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5b57\u6bb5\u5c5e\u6027\uff1a" + name);
        }
        this.errorStr = StrUtil.isNotEmpty((CharSequence)tag) ? FinalValidatorFactory.message.getProperty("Pattern").replace("{message}", tag) : (StrUtil.isEmpty((CharSequence)message) ? FinalValidatorFactory.message.getProperty("Pattern").replace("{message}", name) : message);
        this.name = name;
        this.pattern = Pattern.compile(value);
    }

    @Override
    public void valid(Object target) {
        Object o = null;
        try {
            Field field = target.getClass().getDeclaredField(this.name);
            field.setAccessible(true);
            o = field.get(target);
        }
        catch (Exception e) {
            throw new CheckException(e);
        }
        if (o == null || !this.pattern.matcher(o.toString()).matches()) {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.name);
        }
    }
}

