/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.core;

import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.handle.CustomValidHandle;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

public class FinalValidator {
    private static final Logger log = LoggerFactory.getLogger(FinalValidator.class);
    private static FinalValidatorFactory finalValidatorFactory;
    private static boolean isSpring;

    public FinalValidator(FinalValidatorFactory finalValidatorFactory) {
        if (FinalValidator.finalValidatorFactory != null && !isSpring) {
            throw new CheckException("\u5728spring\u7cfb\u7edf\u4e2d\uff0c\u4e0d\u80fd\u63d0\u524d\u8c03\u7528 FinalValidator.init() \u521d\u59cb\u5316 FinalValidator \uff0c\u5728spring\u4f53\u7cfb\u4e2d\u5df2\u7ecf\u4ea4\u7531bean\u6258\u7ba1\uff0c\u7531spring\u81ea\u52a8\u521d\u59cb\u5316FinalValidator\uff0c\u8bf7\u4e0d\u8981\u624b\u52a8\u63d0\u524d\u4e8espring\u521d\u59cb\u5316FinalValidator");
        }
        FinalValidator.finalValidatorFactory = finalValidatorFactory;
        isSpring = true;
    }

    public static void init() {
        if (finalValidatorFactory != null) {
            if (isSpring) {
                log.warn("FinalValidator \u5df2\u7ecf\u4ea4\u7531spring\u521d\u59cb\u5316\u5b8c\u6bd5\uff01\u65e0\u987b\u624b\u52a8\u521d\u59cb\u5316");
                return;
            }
            log.warn("FinalValidator \u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6bd5\uff01");
            return;
        }
        try {
            finalValidatorFactory = new FinalValidatorFactory();
            InputStream inputStream = FinalValidator.class.getClassLoader().getResourceAsStream("defaultValidated.properties");
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            FinalValidatorFactory.message.load(reader);
            IoUtil.close((Closeable)reader);
            inputStream = FinalValidator.class.getClassLoader().getResourceAsStream("finalValidated.properties");
            if (inputStream != null) {
                reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                Properties finalValidated = new Properties();
                finalValidated.load(reader);
                FinalValidatorFactory.message.putAll((Map<?, ?>)finalValidated);
                IoUtil.close((Closeable)reader);
            }
        }
        catch (Exception e) {
            finalValidatorFactory = null;
            throw new CheckException("final-validator \u521d\u59cb\u5316\u5931\u8d25\uff01", e);
        }
        log.info("final-validator Initialization completed");
    }

    public static void valid(Object target) {
        if (finalValidatorFactory.supports(target.getClass())) {
            finalValidatorFactory.validate(target);
        }
    }

    public static void addCustom(Class<? extends Annotation> annotation, Class<? extends CustomValidHandle> validHandle) {
        if (annotation == null) {
            throw new CheckException("annotation \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (validHandle == null) {
            throw new CheckException("ValidHandle \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FinalValidatorUtils.addCustom(annotation, validHandle);
    }

    static {
        isSpring = false;
    }
}

