/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.core;

import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import top.lingkang.finalvalidated.core.FinalValidator;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.core.FinalValidatorFactorySpring;

@Configuration
public class FinalValidatorConfig {
    private static final Logger log = LoggerFactory.getLogger(FinalValidatorConfig.class);
    @Autowired
    private ResourceLoader resourceLoader;

    @Bean
    public FinalValidatorFactorySpring finalValidatorFactorySpring(@Qualifier(value="requestMappingHandlerAdapter") RequestMappingHandlerAdapter adapter) throws IOException {
        ConfigurableWebBindingInitializer initializer = (ConfigurableWebBindingInitializer)adapter.getWebBindingInitializer();
        FinalValidatorFactorySpring validatorFactorySpring = new FinalValidatorFactorySpring(new FinalValidatorFactory());
        initializer.setValidator((Validator)validatorFactorySpring);
        Resource resource = this.resourceLoader.getResource("classpath:defaultValidated.properties");
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        FinalValidatorFactory.message.load(reader);
        IoUtil.close((Closeable)reader);
        resource = this.resourceLoader.getResource("classpath:finalValidated.properties");
        if (resource.exists()) {
            reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
            Properties finalValidated = new Properties();
            finalValidated.load(reader);
            FinalValidatorFactory.message.putAll((Map<?, ?>)finalValidated);
            IoUtil.close((Closeable)reader);
        }
        log.info("final-validator Initialization completed");
        return validatorFactorySpring;
    }

    @Bean
    public FinalValidator finalValidator(@Qualifier(value="finalValidatorFactorySpring") FinalValidatorFactorySpring spring) {
        return new FinalValidator(spring.finalValidatorFactory);
    }
}

