/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class LengthHandle
implements ValidHandle {
    private String name;
    private long min;
    private long max;
    private String errorStr;

    public LengthHandle(String name, String message, String tag, long min, long max) {
        if (min == max) {
            throw new CheckException("@Length \u6240\u914d\u7f6e\u7684\u6700\u5927\u6700\u5c0f\u503c\u4e0d\u80fd\u76f8\u7b49\uff0c\u5c5e\u6027\u540d\u79f0\uff1a" + name);
        }
        if (min > max) {
            throw new CheckException("@Length \u6240\u914d\u7f6e\u7684min\u503c\u4e0d\u80fd\u5927\u4e8emax\u503c\uff0c\u5c5e\u6027\u540d\u79f0\uff1a" + name);
        }
        if (min < 0L) {
            throw new CheckException("@Length \u6240\u914d\u7f6e\u7684min\u503c\u4e0d\u80fd\u5c0f\u4e8e 0 \uff0c\u5c5e\u6027\u540d\u79f0\uff1a" + name);
        }
        this.errorStr = StrUtil.isNotEmpty((CharSequence)tag) ? FinalValidatorFactory.message.getProperty("Length").replace("{message}", tag).replace("{min}", Long.toString(min)).replace("{max}", Long.toString(max)) : (StrUtil.isEmpty((CharSequence)message) ? FinalValidatorFactory.message.getProperty("Length").replace("{message}", name).replace("{min}", Long.toString(min)).replace("{max}", Long.toString(max)) : message);
        this.name = name;
        this.min = min;
        this.max = max;
    }

    @Override
    public void valid(Object target) {
        Object o = null;
        try {
            Field field = target.getClass().getDeclaredField(this.name);
            field.setAccessible(true);
            o = field.get(target);
        }
        catch (Exception e) {
            throw new CheckException(e);
        }
        if (o == null && this.min == 0L) {
            return;
        }
        if (o == null || (long)o.toString().length() < this.min || (long)o.toString().length() > this.max) {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.name);
        }
    }
}

