/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class AssertTrueHandle
implements ValidHandle {
    private String errorStr;
    private String name;

    public AssertTrueHandle(String name, String message, String tag) {
        this.errorStr = StrUtil.isNotEmpty((CharSequence)tag) ? FinalValidatorFactory.message.getProperty("AssertTrue").replace("{message}", tag) : (StrUtil.isEmpty((CharSequence)message) ? FinalValidatorFactory.message.getProperty("AssertTrue").replace("{message}", name) : message);
        this.name = name;
    }

    @Override
    public void valid(Object target) {
        Object o = null;
        try {
            Field field = target.getClass().getDeclaredField(this.name);
            field.setAccessible(true);
            o = field.get(target);
        }
        catch (Exception e) {
            throw new CheckException(e);
        }
        if (o == null) {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.name);
        }
        if (o.getClass().isAssignableFrom(Boolean.class)) {
            if (!Boolean.parseBoolean(o.toString())) {
                throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.name);
            }
        } else if (o.getClass().isAssignableFrom(String.class)) {
            if (!"true".equals(o) || !Boolean.parseBoolean(o.toString())) {
                throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.name);
            }
        } else {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.name);
        }
    }
}

