/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.TakeValue;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class AssertFalseHandle
implements ValidHandle {
    private String errorStr;
    private Field field;
    private TakeValue takeValue;

    public AssertFalseHandle(Field field, String message, String tag) {
        this.errorStr = StrUtil.isNotEmpty((CharSequence)tag) ? FinalValidatorFactory.message.getProperty("AssertFalse").replace("{message}", tag) : (StrUtil.isEmpty((CharSequence)message) ? FinalValidatorFactory.message.getProperty("AssertFalse").replace("{message}", field.getName()) : message);
        this.field = field;
        this.takeValue = new TakeValue(field);
    }

    @Override
    public void valid(Object target) {
        Object o = this.takeValue.take(target);
        if (o == null) {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.field.getName());
        }
        if (o.getClass().isAssignableFrom(Boolean.class)) {
            if (Boolean.parseBoolean(o.toString())) {
                throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.field.getName());
            }
        } else if (o.getClass().isAssignableFrom(String.class)) {
            if (!"false".equals(o) || Boolean.parseBoolean(o.toString())) {
                throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.field.getName());
            }
        } else {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.field.getName());
        }
    }
}

