/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.TakeValue;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class LengthHandle
implements ValidHandle {
    private Field field;
    private TakeValue takeValue;
    private long min;
    private long max;
    private String errorStr;

    public LengthHandle(Field field, String message, String tag, long min, long max) {
        if (min == max) {
            throw new CheckException("@Length \u6240\u914d\u7f6e\u7684\u6700\u5927\u6700\u5c0f\u503c\u4e0d\u80fd\u76f8\u7b49\uff0c\u5c5e\u6027\u540d\u79f0\uff1a" + field.getName());
        }
        if (min > max) {
            throw new CheckException("@Length \u6240\u914d\u7f6e\u7684min\u503c\u4e0d\u80fd\u5927\u4e8emax\u503c\uff0c\u5c5e\u6027\u540d\u79f0\uff1a" + field.getName());
        }
        if (min < 0L) {
            throw new CheckException("@Length \u6240\u914d\u7f6e\u7684min\u503c\u4e0d\u80fd\u5c0f\u4e8e 0 \uff0c\u5c5e\u6027\u540d\u79f0\uff1a" + field.getName());
        }
        this.errorStr = StrUtil.isNotEmpty((CharSequence)tag) ? FinalValidatorFactory.message.getProperty("Length").replace("{message}", tag).replace("{min}", Long.toString(min)).replace("{max}", Long.toString(max)) : (StrUtil.isEmpty((CharSequence)message) ? FinalValidatorFactory.message.getProperty("Length").replace("{message}", field.getName()).replace("{min}", Long.toString(min)).replace("{max}", Long.toString(max)) : message);
        this.field = field;
        this.min = min;
        this.max = max;
        this.takeValue = new TakeValue(field);
    }

    @Override
    public void valid(Object target) {
        if (this.min == 0L) {
            return;
        }
        Object o = this.takeValue.take(target);
        if (o == null || (long)o.toString().length() < this.min || (long)o.toString().length() > this.max) {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.field.getName());
        }
    }
}

