/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.TakeValue;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class PatternHandle
implements ValidHandle {
    private Field field;
    private TakeValue takeValue;
    private String errorStr;
    private Pattern pattern;

    public PatternHandle(Field field, String message, String tag, String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            throw new CheckException("@Pattern \u6240\u914d\u7f6e\u7684\u6b63\u5219\u8868\u8fbe\u5f0f(value)\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5b57\u6bb5\u5c5e\u6027\uff1a" + field.getName());
        }
        this.errorStr = StrUtil.isNotEmpty((CharSequence)tag) ? FinalValidatorFactory.message.getProperty("Pattern").replace("{message}", tag) : (StrUtil.isEmpty((CharSequence)message) ? FinalValidatorFactory.message.getProperty("Pattern").replace("{message}", field.getName()) : message);
        this.field = field;
        this.takeValue = new TakeValue(field);
        this.pattern = Pattern.compile(value);
    }

    @Override
    public void valid(Object target) {
        Object o = this.takeValue.take(target);
        if (o == null || !this.pattern.matcher(o.toString()).matches()) {
            throw new ValidatedException(this.errorStr, target.getClass().getSimpleName(), this.field.getName());
        }
    }
}

