/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.utils;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import top.lingkang.finalvalidated.constraints.AssertFalse;
import top.lingkang.finalvalidated.constraints.AssertTrue;
import top.lingkang.finalvalidated.constraints.Email;
import top.lingkang.finalvalidated.constraints.Length;
import top.lingkang.finalvalidated.constraints.Max;
import top.lingkang.finalvalidated.constraints.Min;
import top.lingkang.finalvalidated.constraints.NotBlank;
import top.lingkang.finalvalidated.constraints.NotEmpty;
import top.lingkang.finalvalidated.constraints.NotNull;
import top.lingkang.finalvalidated.constraints.Null;
import top.lingkang.finalvalidated.constraints.Pattern;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.handle.AssertFalseHandle;
import top.lingkang.finalvalidated.handle.AssertTrueHandle;
import top.lingkang.finalvalidated.handle.CustomValidHandle;
import top.lingkang.finalvalidated.handle.EmailHandle;
import top.lingkang.finalvalidated.handle.LengthHandle;
import top.lingkang.finalvalidated.handle.MaxHandle;
import top.lingkang.finalvalidated.handle.MinHandle;
import top.lingkang.finalvalidated.handle.NotBlankHandle;
import top.lingkang.finalvalidated.handle.NotEmptyHandle;
import top.lingkang.finalvalidated.handle.NotNullHandle;
import top.lingkang.finalvalidated.handle.NullHandle;
import top.lingkang.finalvalidated.handle.PatternHandle;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class FinalValidatorUtils {
    private static final Set<Class<? extends Annotation>> annotation = new HashSet<Class<? extends Annotation>>();
    private static final Map<Class<? extends Annotation>, Class<? extends CustomValidHandle>> customHandle = new HashMap<Class<? extends Annotation>, Class<? extends CustomValidHandle>>();

    public static void addCustom(Class<? extends Annotation> annotation, Class<? extends CustomValidHandle> validHandle) {
        if (FinalValidatorUtils.annotation.contains(annotation)) {
            throw new CheckException("\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0\u81ea\u5b9a\u4e49\u6ce8\u89e3\uff1a" + annotation.getName());
        }
        FinalValidatorUtils.annotation.add(annotation);
        customHandle.put(annotation, validHandle);
    }

    public static boolean existsConstraints(Field[] fields) {
        for (Field field : fields) {
            if (!FinalValidatorUtils.existsConstraints(field.getAnnotations())) continue;
            return true;
        }
        return false;
    }

    public static boolean existsConstraints(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!FinalValidatorUtils.annotation.contains(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean annotationConstraints(Annotation annotation) {
        return FinalValidatorUtils.annotation.contains(annotation.annotationType());
    }

    public static ValidHandle annotationToValidHandle(Field field, Annotation annotation, String tag) {
        if (annotation.annotationType() == NotBlank.class) {
            NotBlank notBlank = (NotBlank)annotation;
            return new NotBlankHandle(field, notBlank.message(), tag == null ? notBlank.tag() : tag);
        }
        if (annotation.annotationType() == Min.class) {
            Min min = (Min)annotation;
            return new MinHandle(field, min.message(), tag == null ? min.tag() : tag, min.value());
        }
        if (annotation.annotationType() == Max.class) {
            Max max = (Max)annotation;
            return new MaxHandle(field, max.message(), tag == null ? max.tag() : tag, max.value());
        }
        if (annotation.annotationType() == Length.class) {
            Length length = (Length)annotation;
            return new LengthHandle(field, length.message(), tag == null ? length.tag() : tag, length.min(), length.max());
        }
        if (annotation.annotationType() == NotEmpty.class) {
            NotEmpty notEmpty = (NotEmpty)annotation;
            return new NotEmptyHandle(field, notEmpty.message(), tag == null ? notEmpty.tag() : tag);
        }
        if (annotation.annotationType() == Email.class) {
            Email email = (Email)annotation;
            return new EmailHandle(field, email.message(), tag == null ? email.tag() : tag, email.value());
        }
        if (annotation.annotationType() == Pattern.class) {
            Pattern pattern = (Pattern)annotation;
            return new PatternHandle(field, pattern.message(), tag == null ? pattern.tag() : tag, pattern.value());
        }
        if (annotation.annotationType() == Null.class) {
            Null aNull = (Null)annotation;
            return new NullHandle(field, aNull.message(), tag == null ? aNull.tag() : tag);
        }
        if (annotation.annotationType() == NotNull.class) {
            NotNull notNull = (NotNull)annotation;
            return new NotNullHandle(field, notNull.message(), tag == null ? notNull.tag() : tag);
        }
        if (annotation.annotationType() == AssertFalse.class) {
            AssertFalse assertFalse = (AssertFalse)annotation;
            return new AssertFalseHandle(field, assertFalse.message(), tag == null ? assertFalse.tag() : tag);
        }
        if (annotation.annotationType() == AssertTrue.class) {
            AssertTrue assertTrue = (AssertTrue)annotation;
            return new AssertTrueHandle(field, assertTrue.message(), tag == null ? assertTrue.tag() : tag);
        }
        Class<? extends CustomValidHandle> validHandle = customHandle.get(annotation.annotationType());
        if (validHandle != null) {
            try {
                return validHandle.getConstructor(Field.class, Annotation.class).newInstance(field, annotation);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new CheckException(annotation.annotationType() + " \u672a\u627e\u5230\u5bf9\u5e94\u7684 ValidHandle \u5904\u7406\u7c7b\u5b9e\u73b0\uff01");
    }

    public static boolean notMin(Object o, long value) {
        if (o instanceof Integer) {
            return (long)Integer.parseInt(o.toString()) < value;
        }
        if (o instanceof Long) {
            return Long.parseLong(o.toString()) < value;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).compareTo(new BigDecimal(value)) < 0;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue() < Float.parseFloat(String.valueOf(value));
        }
        if (o instanceof Double) {
            return (Double)o < Double.parseDouble(String.valueOf(value));
        }
        if (o instanceof Short) {
            return (long)((Short)o).shortValue() < value;
        }
        throw new CheckException("long \u65e0\u6cd5\u4e0e " + o.getClass() + " \u8fdb\u884c\u7c7b\u578b\u6bd4\u8f83");
    }

    public static boolean notMax(Object o, long value) {
        if (o instanceof Integer) {
            return (long)Integer.parseInt(o.toString()) > value;
        }
        if (o instanceof Long) {
            return Long.parseLong(o.toString()) > value;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).compareTo(new BigDecimal(value)) > 0;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue() > Float.parseFloat(String.valueOf(value));
        }
        if (o instanceof Double) {
            return (Double)o > Double.parseDouble(String.valueOf(value));
        }
        if (o instanceof Short) {
            return (long)((Short)o).shortValue() > value;
        }
        throw new CheckException("long \u65e0\u6cd5\u4e0e " + o.getClass() + " \u8fdb\u884c\u7c7b\u578b\u6bd4\u8f83");
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !FinalValidatorUtils.isEmpty(str);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (FinalValidatorUtils.isBlankChar(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || c == 6158;
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        annotation.add(NotBlank.class);
        annotation.add(Min.class);
        annotation.add(Max.class);
        annotation.add(Length.class);
        annotation.add(NotEmpty.class);
        annotation.add(Email.class);
        annotation.add(Pattern.class);
        annotation.add(Null.class);
        annotation.add(NotNull.class);
        annotation.add(AssertFalse.class);
        annotation.add(AssertTrue.class);
    }
}

