/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import java.lang.reflect.Field;
import java.util.List;
import top.lingkang.finalvalidated.constraints.Tag;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.ValidHandle;

public class NestingValidHandle
implements ValidHandle {
    private final List<ValidHandle> handles;
    private final Field field;
    private final String nullError;
    private final String tip;

    public NestingValidHandle(List<ValidHandle> handles, Field field) {
        this.handles = handles;
        this.field = field;
        Tag tag = field.getAnnotation(Tag.class);
        this.tip = tag != null ? tag.value() : field.getName();
        this.nullError = this.tip + " \u53c2\u6570\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
    }

    @Override
    public void valid(Object target) {
        Object val = null;
        try {
            val = this.field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (val == null) {
            throw new ValidatedException(this.nullError);
        }
        try {
            for (ValidHandle handle : this.handles) {
                handle.valid(val);
            }
        }
        catch (ValidatedException e) {
            e.setMessage(this.tip + " --> " + e.getMessage());
            throw e;
        }
    }
}

