/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import top.lingkang.finalvalidated.constraints.Tag;
import top.lingkang.finalvalidated.core.CheckObject;
import top.lingkang.finalvalidated.core.ValidObject;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.handle.NestingValidHandle;
import top.lingkang.finalvalidated.handle.ValidHandle;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

public class FinalValidatorFactory {
    private static final Map<Class<?>, CheckObject> cache = new HashMap();
    private static final List<Class<?>> currentNestingClass = new ArrayList();
    public static Properties message = new Properties();

    public boolean supports(Class<?> clazz) {
        CheckObject check = cache.get(clazz);
        if (check != null) {
            return check.isNeed();
        }
        check = new CheckObject();
        if (FinalValidatorUtils.existsConstraints(clazz)) {
            check.setNeed(true);
            check.setHandles(this.initValidHandle(clazz));
        }
        cache.put(clazz, check);
        return check.isNeed();
    }

    public void validate(Object target) {
        CheckObject checkObject = cache.get(target.getClass());
        for (ValidHandle handle : checkObject.getHandles()) {
            handle.valid(target);
        }
    }

    private synchronized List<ValidHandle> initValidHandle(Class<?> clazz) {
        ArrayList<ValidHandle> list = new ArrayList<ValidHandle>();
        List<Field> fieldList = FinalValidatorUtils.getAllFields(clazz);
        for (Field field : fieldList) {
            List<Annotation> validAnn;
            if (field.getType() != clazz && !currentNestingClass.contains(field.getType()) && field.isAnnotationPresent(ValidObject.class)) {
                currentNestingClass.add(field.getType());
                List<Field> checkField = FinalValidatorUtils.getAllCheckField(field.getType());
                if (!checkField.isEmpty()) {
                    field.setAccessible(true);
                    list.add(new NestingValidHandle(this.initValidHandle(field.getType()), field));
                    continue;
                }
            }
            if ((validAnn = FinalValidatorUtils.getValidAnn(field)).isEmpty()) continue;
            for (Annotation annotation : validAnn) {
                try {
                    String strTag = null;
                    Tag tag = field.getAnnotation(Tag.class);
                    if (tag != null && FinalValidatorUtils.isNotEmpty(tag.value())) {
                        strTag = tag.value();
                    }
                    list.add(FinalValidatorUtils.annotationToValidHandle(field, annotation, strTag));
                }
                catch (CheckException e) {
                    throw new CheckException("\u6821\u9a8c\u5f02\u5e38\u5bf9\u8c61\uff1a" + clazz.getName(), e);
                }
            }
        }
        currentNestingClass.clear();
        return list;
    }

    public void clearCache() {
        cache.clear();
        currentNestingClass.clear();
        FinalValidatorUtils.clearCache();
    }
}

