/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import java.lang.reflect.Field;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.TakeValue;
import top.lingkang.finalvalidated.handle.ValidHandle;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

public class MinHandle
implements ValidHandle {
    private final Field field;
    private final long value;
    private final TakeValue takeValue;
    private final String errorStr;
    private String notNullStr;

    public MinHandle(Field field, String message, String tag, long value) {
        if (FinalValidatorUtils.isNotEmpty(tag)) {
            this.errorStr = FinalValidatorFactory.message.getProperty("Min").replace("{message}", tag).replace("{value}", Long.toString(value));
            this.notNullStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", tag);
        } else if (FinalValidatorUtils.isEmpty(message)) {
            this.errorStr = FinalValidatorFactory.message.getProperty("Min").replace("{message}", field.getName()).replace("{value}", Long.toString(value));
            this.notNullStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", field.getName());
        } else {
            this.errorStr = message;
        }
        this.value = value;
        this.field = field;
        this.takeValue = new TakeValue(field);
    }

    @Override
    public void valid(Object target) {
        Object take = this.takeValue.take(target);
        if (take == null) {
            throw new ValidatedException(this.notNullStr, target.getClass(), this.field.getName());
        }
        if (FinalValidatorUtils.notMin(take, this.value)) {
            throw new ValidatedException(this.errorStr, target.getClass(), this.field.getName());
        }
    }
}

