/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import java.lang.reflect.Field;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.TakeValue;
import top.lingkang.finalvalidated.handle.ValidHandle;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

public class NotBlankHandle
implements ValidHandle {
    private final String errorStr;
    private final TakeValue takeValue;
    private final Field field;

    public NotBlankHandle(Field field, String message, String tag) {
        this.errorStr = FinalValidatorUtils.isNotEmpty(tag) ? FinalValidatorFactory.message.getProperty("NotBlank").replace("{message}", tag) : (FinalValidatorUtils.isEmpty(message) ? FinalValidatorFactory.message.getProperty("NotBlank").replace("{message}", field.getName()) : message);
        this.field = field;
        this.takeValue = new TakeValue(field);
    }

    @Override
    public void valid(Object target) {
        Object take = this.takeValue.take(target);
        if (take == null || FinalValidatorUtils.isBlank(take.toString())) {
            throw new ValidatedException(this.errorStr, target.getClass(), this.field.getName());
        }
    }
}

