package top.lingkang.finalvalidated.constraints;

import java.lang.annotation.*;

/**
 * @author lingkang <br/>
 * created by 2024/2/3<br/>
 * 注解tag属性默认值<br/>
 * 消息提示的tag值，message（不为空时） 比 tag 优先级更高，此注解优先级低于其他注解的tag属性。通常用于多注解的默认tag<br/>
 * 例示：之前写法：
 * <pre>
 * {@code
 * @Length(min = 3, max = 16, tag="密码")
 * @NotBlank(tag="密码")
 * String password;
 * }
 * </pre>
 * <br/>
 * 使用 @Tag 之后写法：
 * <pre>
 * {@code
 *  @Tag("密码")
 *  @Length(min = 3, max = 16) // 密码 字符长度范围： 3 ~ 16
 *  @NotBlank // 密码不能为空
 *  String password;
 *
 *  // 注意优先级，message > 校验注解属性tag > @Tag
 *  @Tag("账号")
 *  @Length(min = 3, max = 16, tag = "输入的账号") // 输入的账号 字符长度范围： 3 ~ 16
 *  @NotBlank(message = "输入的账号不能为空") // 输入的账号不能为空
 *  String username;
 * }
 * </pre>
 * 其他写法：作用于嵌套校验对象(v2.3.0+)
 * <pre>
 * {@code
 * @Data
 * public class NestingParam1 {
 *     @Tag("嵌套2属性") // v2.3.0+
 *     private NestingParam2 nestingParam2;
 *     @Tag("嵌套1")
 *     @NotBlank
 *     private String nesting1;
 * }
 * }
 * </pre>
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Tag {

    /**
     * 消息提示的tag值，message（不为空时） 比 tag 优先级更高，此注解优先级低于其他注解的tag属性。通常用于多注解的默认tag
     */
    String value() default "";
}
