package top.lingkang.finalvalidated.core;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 校验对象属性，可以配置忽略哪些字段<br/>
 * 添加在要校验的对象类上
 *
 * @author lingkang
 * created by 2025-07-27
 * @serial 2.3.3
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidObjectAttr {

    /**
     * 校验忽略字段，通常用于继承校验对象后，忽略指定父类的字段属性<br/>
     * 您也可以忽略当前对象的属性。<br/>
     * 应用场景：不想频繁编写入参校验对象的属性，<br/>
     * 例如已经存在 UserAddParam 类，那么编辑 UserEditParam 入参类只需要继承 UserAddParam <br/>
     * 并通过 @ValidObjectAttr 注解忽略一些不需要校验的字段即可。
     */
    String[] ignore() default {};
}
