package top.lingkang.finalvalidated.handle;

import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

import java.lang.reflect.Field;

/**
 * @author lingkang
 * Created by 2024/1/26
 */
public class MinHandle implements ValidHandle {
    private final Field field;
    private final long value;
    private final String errorStr;
    private String notNullStr;

    public MinHandle(Field field, String message, String tag, long value) {
        if (FinalValidatorUtils.isNotEmpty(message)) {
            errorStr = message;
        } else if (FinalValidatorUtils.isNotEmpty(tag)) {
            errorStr = FinalValidatorFactory.message.getProperty("Min")
                    .replace("{message}", tag)
                    .replace("{value}", Long.toString(value));
            notNullStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", tag);
        } else {
            errorStr = FinalValidatorFactory.message.getProperty("Min")
                    .replace("{message}", field.getName())
                    .replace("{value}", Long.toString(value));
            notNullStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", field.getName());
        }
        this.value = value;
        this.field = field;
    }

    @Override
    public void valid(Object target) {
        Object o = getAttrValue(target, field.getName());
        if (o == null) {
            throw new ValidatedException(notNullStr, target.getClass(), field.getName());
        }
        if (FinalValidatorUtils.notMin(o, value)) {
            throw new ValidatedException(errorStr, target.getClass(), field.getName());
        }
    }
}
