package top.lingkang.finalvalidated.handle;

import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

import java.lang.reflect.Field;

/**
 * @author lingkang
 * Created by 2024/1/26
 */
public class NotEmptyHandle implements ValidHandle {
    private final String errorStr;
    private final Field field;

    public NotEmptyHandle(Field field, String message, String tag) {
        if (FinalValidatorUtils.isNotEmpty(message)) {
            errorStr = message;
        } else if (FinalValidatorUtils.isNotEmpty(tag)) {
            errorStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", tag);
        } else {
            errorStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", field.getName());
        }
        this.field = field;
    }

    @Override
    public void valid(Object target) {
        Object o = getAttrValue(target, field.getName());
        if (o == null || FinalValidatorUtils.isEmpty(o.toString())) {
            throw new ValidatedException(errorStr, target.getClass(), field.getName());
        }
    }
}
