package top.lingkang.finalvalidated.handle;

import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

/**
 * @author lingkang
 * Created by 2024/1/26
 * 校验处理实现
 */
public interface ValidHandle {

    /**
     * 校验，自定义校验时，校验失败建议抛出 {@link top.lingkang.finalvalidated.error.ValidatedException} 异常
     *
     * @param target 待校验对象
     */
    void valid(Object target);

    /**
     * 通过属性名getter获取对象属性
     *
     * @param target 对象
     * @param name   属性名
     * @return 属性值
     * @since 2.4.0
     */
    default Object getAttrValue(Object target, String name) {
        return FinalValidatorUtils.getValueRaw(target, name);
    }
}
