/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.core;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import top.lingkang.finalvalidated.core.FinalValidator;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.core.FinalValidatorFactorySpring;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

@Configuration
public class FinalValidatorConfig {
    private static final Logger log = LoggerFactory.getLogger(FinalValidatorConfig.class);
    @Autowired
    private ResourceLoader resourceLoader;
    private FinalValidatorFactory finalValidatorFactory;

    @Bean
    public FinalValidatorFactorySpring finalValidatorFactorySpring(@Autowired RequestMappingHandlerAdapter adapter) throws IOException {
        ConfigurableWebBindingInitializer initializer = (ConfigurableWebBindingInitializer)adapter.getWebBindingInitializer();
        this.finalValidatorFactory = new FinalValidatorFactory();
        FinalValidatorFactorySpring validatorFactorySpring = new FinalValidatorFactorySpring(this.finalValidatorFactory);
        initializer.setValidator((Validator)validatorFactorySpring);
        Resource resource = this.resourceLoader.getResource("classpath:defaultValidated.properties");
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        FinalValidatorFactory.message.load(reader);
        FinalValidatorUtils.close(reader);
        resource = this.resourceLoader.getResource("classpath:finalValidated.properties");
        if (resource.exists()) {
            reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
            Properties finalValidated = new Properties();
            finalValidated.load(reader);
            FinalValidatorFactory.message.putAll((Map<?, ?>)finalValidated);
            FinalValidatorUtils.close(reader);
        }
        log.info("final-validator Initialization completed");
        return validatorFactorySpring;
    }

    @Bean
    public FinalValidator finalValidator(@Autowired FinalValidatorFactorySpring spring) {
        return new FinalValidator(spring.finalValidatorFactory);
    }

    public void clearCache() {
        this.finalValidatorFactory.clearCache();
    }
}

