/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import java.lang.reflect.Field;
import java.util.regex.Pattern;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.CheckException;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.ValidHandle;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

public class EmailHandle
implements ValidHandle {
    private final Field field;
    private final String errorStr;
    private final Pattern pattern;

    public EmailHandle(Field field, String message, String tag, String value) {
        if (FinalValidatorUtils.isBlank(value)) {
            throw new CheckException("@Email \u6240\u914d\u7f6e\u7684\u6b63\u5219\u8868\u8fbe\u5f0f(value)\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5b57\u6bb5\u5c5e\u6027\uff1a" + field.getName());
        }
        this.errorStr = FinalValidatorUtils.isNotEmpty(message) ? message : (FinalValidatorUtils.isNotEmpty(tag) ? FinalValidatorFactory.message.getProperty("Email").replace("{message}", tag) : FinalValidatorFactory.message.getProperty("Email").replace("{message}", field.getName()));
        this.field = field;
        this.pattern = Pattern.compile(value);
    }

    @Override
    public void valid(Object target) {
        Object o = this.getAttrValue(target, this.field.getName());
        if (o == null || !this.pattern.matcher(o.toString()).matches()) {
            throw new ValidatedException(this.errorStr, target.getClass(), this.field.getName());
        }
    }
}

