/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.handle;

import java.lang.reflect.Field;
import top.lingkang.finalvalidated.core.FinalValidatorFactory;
import top.lingkang.finalvalidated.error.ValidatedException;
import top.lingkang.finalvalidated.handle.ValidHandle;
import top.lingkang.finalvalidated.utils.FinalValidatorUtils;

public class MaxHandle
implements ValidHandle {
    private final Field field;
    private final long value;
    private final String errorStr;
    private String notNullStr;

    public MaxHandle(Field field, String message, String tag, long value) {
        if (FinalValidatorUtils.isNotEmpty(message)) {
            this.errorStr = message;
        } else if (FinalValidatorUtils.isNotEmpty(tag)) {
            this.errorStr = FinalValidatorFactory.message.getProperty("Max").replace("{message}", tag).replace("{value}", Long.toString(value));
            this.notNullStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", tag);
        } else {
            this.errorStr = FinalValidatorFactory.message.getProperty("Max").replace("{message}", field.getName()).replace("{value}", Long.toString(value));
            this.notNullStr = FinalValidatorFactory.message.getProperty("NotEmpty").replace("{message}", field.getName());
        }
        this.field = field;
        this.value = value;
    }

    @Override
    public void valid(Object target) {
        Object o = this.getAttrValue(target, this.field.getName());
        if (o == null) {
            throw new ValidatedException(this.notNullStr, target.getClass(), this.field.getName());
        }
        if (FinalValidatorUtils.notMax(o, this.value)) {
            throw new ValidatedException(this.errorStr, target.getClass(), this.field.getName());
        }
    }
}

