/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalvalidated.utils;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class GetterUtils {
    protected static Map<String, Method> CACHE_METHOD = new ConcurrentHashMap<String, Method>();

    GetterUtils() {
    }

    public static <T> T getValue(Object obj, String propertyName) {
        Object value = GetterUtils.getValueRaw(obj, propertyName);
        return (T)value;
    }

    public static Object getValueRaw(Object obj, String propertyName) {
        if (obj == null) {
            throw new IllegalArgumentException("\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Method getter = CACHE_METHOD.get(obj.getClass().getName() + propertyName);
            if (getter == null) {
                getter = GetterUtils.findGetterMethod(obj.getClass(), propertyName);
                CACHE_METHOD.put(obj.getClass().getName() + propertyName, getter);
            }
            return getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u5c5e\u6027\u503c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static <T> T getValueSafe(Object obj, String propertyName, T defaultValue) {
        try {
            return GetterUtils.getValue(obj, propertyName);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T> T getValueSafe(Object obj, String propertyName) {
        return GetterUtils.getValueSafe(obj, propertyName, null);
    }

    private static Method findGetterMethod(Class<?> clazz, String propertyName) {
        String[] possibleMethods;
        for (String methodName : possibleMethods = new String[]{"get" + GetterUtils.capitalize(propertyName), "is" + GetterUtils.capitalize(propertyName)}) {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new RuntimeException("\u5728\u7c7b " + clazz.getName() + " \u4e2d\u672a\u627e\u5230\u5c5e\u6027 '" + propertyName + "' \u7684 getter \u65b9\u6cd5");
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

