/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm;

import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import top.lingkang.mm.SpringMapperManage;
import top.lingkang.mm.gen.DefaultIdGenerate;
import top.lingkang.mm.gen.IdGenerate;
import top.lingkang.mm.orm.MapperManage;
import top.lingkang.mm.override.MagicReflectorFactory;
import top.lingkang.mm.page.MagicPageInterceptor;

@ConditionalOnSingleCandidate(value=SqlSessionFactory.class)
public class MybatisMagicAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MybatisMagicAutoConfiguration.class);

    @Bean
    public MapperManage mapperManage(@Autowired SqlSessionFactory sqlSessionFactory, @Autowired SqlSessionTemplate sessionTemplate) {
        SpringMapperManage manage = new SpringMapperManage(sqlSessionFactory.getConfiguration(), (SqlSession)sessionTemplate);
        ReflectorFactory reflectorFactory = sqlSessionFactory.getConfiguration().getReflectorFactory();
        if (reflectorFactory instanceof DefaultReflectorFactory) {
            sqlSessionFactory.getConfiguration().setReflectorFactory((ReflectorFactory)new MagicReflectorFactory());
            log.debug("\u52a0\u8f7d\u53cd\u5c04\u5de5\u5382\u5b8c\u6210");
        }
        sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new MagicPageInterceptor());
        log.debug("\u52a0\u8f7d\u5206\u9875\u62e6\u622a\u5b8c\u6210");
        manage.setIdGenerate((IdGenerate)new DefaultIdGenerate());
        if (!sqlSessionFactory.getConfiguration().isMapUnderscoreToCamelCase()) {
            log.info("\u5efa\u8bae\u5f00\u542f\u4e0b\u5212\u7ebf\u8f6c\u9a7c\u5cf0, \u4ee5\u83b7\u5f97\u589e\u5f3a\u4f53\u9a8c, application.properties \u4e2d\u6dfb\u52a0: mybatis.configuration.map-underscore-to-camel-case=true");
        }
        return manage;
    }
}

