/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.transaction.TransactionManage;

public class MagicSqlSession
implements SqlSession {
    private static final Logger log = LoggerFactory.getLogger(MagicSqlSession.class);
    private SqlSessionFactory sqlSessionFactory;
    private ExecutorType executorType;
    private SqlSession sessionProxy;

    public MagicSqlSession(SqlSessionFactory sqlSessionFactory, ExecutorType executorType) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.executorType = executorType;
        this.sessionProxy = (SqlSession)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{SqlSession.class}, (InvocationHandler)new SqlSessionProxy());
    }

    public <T> T selectOne(String statement) {
        return (T)this.sessionProxy.selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.sessionProxy.selectOne(statement, parameter);
    }

    public <E> List<E> selectList(String statement) {
        return this.sessionProxy.selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.sessionProxy.selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.sessionProxy.selectList(statement, parameter, rowBounds);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.sessionProxy.selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.sessionProxy.selectMap(statement, (Object)mapKey, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.sessionProxy.selectMap(statement, (Object)mapKey, mapKey, rowBounds);
    }

    public <T> Cursor<T> selectCursor(String statement) {
        return this.sessionProxy.selectCursor(statement);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter) {
        return this.sessionProxy.selectCursor(statement, parameter);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter, RowBounds rowBounds) {
        return this.sessionProxy.selectCursor(statement);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.sessionProxy.select(statement, parameter, handler);
    }

    public void select(String statement, ResultHandler handler) {
        this.sessionProxy.select(statement, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.sessionProxy.select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.sessionProxy.insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.sessionProxy.insert(statement, parameter);
    }

    public int update(String statement) {
        return this.sessionProxy.update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.sessionProxy.update(statement, parameter);
    }

    public int delete(String statement) {
        return this.sessionProxy.delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.sessionProxy.delete(statement, parameter);
    }

    public void commit() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff0c\u5df2\u7ecf\u4ea4\u7531 final-magic \u7ba1\u7406\u4e8b\u52a1");
    }

    public void commit(boolean force) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff0c\u5df2\u7ecf\u4ea4\u7531 final-magic \u7ba1\u7406\u4e8b\u52a1");
    }

    public void rollback() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff0c\u5df2\u7ecf\u4ea4\u7531 final-magic \u7ba1\u7406\u4e8b\u52a1");
    }

    public void rollback(boolean force) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff0c\u5df2\u7ecf\u4ea4\u7531 final-magic \u7ba1\u7406\u4e8b\u52a1");
    }

    public List<BatchResult> flushStatements() {
        return this.sessionProxy.flushStatements();
    }

    public void close() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff0c\u5df2\u7ecf\u4ea4\u7531 final-magic \u7ba1\u7406\u8fde\u63a5");
    }

    public void clearCache() {
        this.sessionProxy.clearCache();
    }

    public Configuration getConfiguration() {
        return this.sqlSessionFactory.getConfiguration();
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.getConfiguration().getMapper(type, (SqlSession)this);
    }

    public Connection getConnection() {
        SqlSession session = this.sqlSessionFactory.openSession(this.executorType);
        log.debug("\u83b7\u53d6\u7684 Connection \u9700\u8981\u624b\u52a8\u5173\u95ed");
        return session.getConnection();
    }

    private class SqlSessionProxy
    implements InvocationHandler {
        private SqlSessionProxy() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            SqlSession session = MagicSqlSession.this.sqlSessionFactory.openSession(MagicSqlSession.this.executorType);
            log.debug("\u83b7\u53d6\u8fde\u63a5");
            Object result = null;
            try {
                result = method.invoke((Object)session, args);
            }
            catch (Exception e) {
                if (TransactionManage.isTransaction()) {
                    TransactionManage.rollback();
                }
                throw e;
            }
            finally {
                if (!TransactionManage.isTransaction()) {
                    session.close();
                    log.debug("\u5173\u95ed\u8fde\u63a5");
                }
            }
            return result;
        }
    }
}

