/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import top.lingkang.mm.annotation.Table;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.orm.BaseInterface;
import top.lingkang.mm.orm.BaseMapperSql;
import top.lingkang.mm.orm.MagicEntity;
import top.lingkang.mm.orm.MagicEntityUtils;
import top.lingkang.mm.orm.QueryColumn;

public class BaseMapperDriver
extends XMLLanguageDriver
implements LanguageDriver {
    private Field loadedResources;
    private Field keyProperties;
    private Field keyColumns;
    private Field resultClass;
    private List<String> mapperMethod = new ArrayList<String>();

    public BaseMapperDriver() {
        try {
            this.loadedResources = Configuration.class.getDeclaredField("loadedResources");
            this.loadedResources.setAccessible(true);
            this.keyProperties = MappedStatement.class.getDeclaredField("keyProperties");
            this.keyProperties.setAccessible(true);
            this.keyColumns = MappedStatement.class.getDeclaredField("keyColumns");
            this.keyColumns.setAccessible(true);
            this.resultClass = ResultMap.class.getDeclaredField("type");
            this.resultClass.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public SqlSource createSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        return super.createSqlSource(configuration, script, parameterType);
    }

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        if (!BaseMapperSql.isBaseMapperSql(script)) {
            return super.createSqlSource(configuration, script, parameterType);
        }
        List<BaseInterface> interfaces = this.loadedBaseMapperInterface(configuration);
        BaseInterface interface_ = null;
        for (BaseInterface baseInterface : interfaces) {
            if (this.mapperMethod.contains(baseInterface.getInterfaceStr() + "-" + script)) continue;
            interface_ = baseInterface;
            break;
        }
        this.mapperMethod.add(interface_.getInterfaceStr() + "-" + script);
        MagicEntity entity = MagicEntityUtils.getMagicEntity(configuration, interface_.getEntityClass());
        if ("magic_base_selectAll".equals(script)) {
            script = entity.getSelectTableSql();
        } else if ("magic_base_createQuery".equals(script)) {
            script = entity.getSelectTableSql() + " ${q.sql}";
        } else if ("magic_base_selectById".equals(script)) {
            if (entity.getIdIndex() == -1) {
                script = "-1: \u67e5\u8be2\u7684\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u67e5\u8be2\u5931\u8d25";
            } else {
                script = entity.getSelectTableSql() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "id" + "}";
            }
        } else if ("magic_base_existsById".equals(script)) {
            if (entity.getIdIndex() == -1) {
                script = "-1: \u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u67e5\u8be2\u5931\u8d25";
            } else {
                script = "select count(*) from " + entity.getTableName() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "id" + "}";
            }
        } else if ("magic_base_selectColumn".equals(script)) {
            script = "select ${q2.columns} from " + entity.getTableName() + " ${q2.sql}";
        } else if ("magic_base_insert".equals(script)) {
            script = "insert into " + entity.getTableName() + "(" + MagicEntityUtils.getColumns(entity.getColumnName(), null) + ") values(" + MagicEntityUtils.getInsertValues(entity, "e") + ")";
        } else if ("magic_base_insertBatch".equals(script)) {
            script = "<script>insert into " + entity.getTableName() + "(" + MagicEntityUtils.getColumns(entity.getColumnName(), null) + ") values <foreach collection=\"" + "list" + "\" index=\"\" item=\"e\" separator=\",\">(" + MagicEntityUtils.getInsertPrefixValues(entity, "e") + ")</foreach></script>";
        } else if ("magic_base_updateById".equals(script)) {
            script = entity.getIdIndex() != -1 ? "update " + entity.getTableName() + " set " + MagicEntityUtils.getSetColumns(entity, "e") + " where " + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "e" + "." + entity.getFields().get(entity.getIdIndex()).getName() + "}" : "-1";
        } else if ("magic_base_deleteById".equals(script)) {
            if (entity.getIdIndex() == -1) {
                script = "-1: \u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u5220\u9664\u5931\u8d25";
            } else {
                script = "delete from " + entity.getTableName() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "id" + "}";
            }
        }
        return super.createSqlSource(configuration, script, parameterType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterHandler createParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        if (mappedStatement.getSqlCommandType() == SqlCommandType.SELECT) {
            MapperMethod.ParamMap map;
            if (boundSql.getSql().startsWith("-1")) {
                throw new MagicException(boundSql.getSql());
            }
            if (!(parameterObject instanceof MapperMethod.ParamMap) || !(map = (MapperMethod.ParamMap)parameterObject).containsKey((Object)"q2")) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
            Object object = map.get((Object)"q2");
            try {
                this.resultClass.set(mappedStatement.getResultMaps().get(0), ((QueryColumn)object).getResultClass());
                return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
            }
            catch (IllegalAccessException e) {
                throw new MagicException(e);
            }
        }
        if (mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
            if (parameterObject == null) {
                throw new MagicException("\u63d2\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a! ");
            }
            MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
            Object object = map.get((Object)"e");
            MagicEntity entity = MagicEntityUtils.getMagicEntity(mappedStatement.getConfiguration(), object.getClass());
            if (entity.getIdIndex() == -1) {
                throw new MagicException("\u66f4\u65b0\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName());
            }
            MagicEntityUtils.execPreUpdate(entity, object);
            return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
        }
        if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            try {
                if (parameterObject == null || parameterObject.getClass() != MapperMethod.ParamMap.class) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
                MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
                if (map.containsKey((Object)"e")) {
                    Object object = map.get((Object)"e");
                    MagicEntity entity = MagicEntityUtils.getMagicEntity(mappedStatement.getConfiguration(), object.getClass());
                    if (entity.getIdIndex() != -1) {
                        MagicEntityUtils.setIdValue(object, mappedStatement.getConfiguration(), entity);
                        this.keyProperties.set(mappedStatement, new String[]{entity.getFields().get(entity.getIdIndex()).getName()});
                        this.keyColumns.set(mappedStatement, new String[]{entity.getColumnName().get(entity.getIdIndex())});
                    }
                    MagicEntityUtils.execPreUpdate(entity, object);
                    return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
                }
                Object object = map.get((Object)"list");
                if (object == null) {
                    throw new MagicException("\u63d2\u5165\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                List list = (List)object;
                if (list.isEmpty()) {
                    throw new MagicException("\u63d2\u5165\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                MagicEntity entity = MagicEntityUtils.getMagicEntity(mappedStatement.getConfiguration(), list.get(0).getClass());
                if (entity.getIdIndex() != -1) {
                    for (Object o : list) {
                        MagicEntityUtils.setIdValue(o, mappedStatement.getConfiguration(), entity);
                    }
                    this.keyProperties.set(mappedStatement, new String[]{entity.getFields().get(entity.getIdIndex()).getName()});
                    this.keyColumns.set(mappedStatement, new String[]{entity.getColumnName().get(entity.getIdIndex())});
                }
                MagicEntityUtils.execPreUpdateList(entity, list);
                return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
            }
            catch (Exception e) {
                throw new MagicException(e);
            }
        }
        if (mappedStatement.getSqlCommandType() != SqlCommandType.DELETE) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
        if (parameterObject == null) {
            throw new MagicException("\u5220\u9664\u7684id\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a! ");
        }
        if (boundSql.getSql().startsWith("-1")) {
            throw new MagicException(boundSql.getSql());
        }
        MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
        Object object = map.get((Object)"id");
        if (object.getClass().getAnnotation(Table.class) == null) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
        MagicEntity entity = MagicEntityUtils.getMagicEntity(mappedStatement.getConfiguration(), object.getClass());
        if (entity.getIdIndex() == -1) {
            throw new MagicException("\u5220\u9664\u7684\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName());
        }
        Object id = null;
        try {
            id = entity.getFields().get(entity.getIdIndex()).get(object);
        }
        catch (IllegalAccessException e) {
            throw new MagicException(e);
        }
        map.put((Object)"id", id);
        return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
    }

    private List<BaseInterface> loadedBaseMapperInterface(Configuration configuration) {
        ArrayList<BaseInterface> result = new ArrayList<BaseInterface>();
        try {
            HashSet set = (HashSet)this.loadedResources.get(configuration);
            for (String inter : set) {
                String interfaceName;
                Class<?> interface_;
                Type[] genericInterfaces;
                if (!inter.startsWith("interface") || (genericInterfaces = (interface_ = ((Object)((Object)this)).getClass().getClassLoader().loadClass(inter.split(" ")[1])).getGenericInterfaces()).length == 0 || (interfaceName = this.getBaseMapperInterfaceName(genericInterfaces)) == null) continue;
                BaseInterface baseInterface = new BaseInterface();
                baseInterface.setInterfaceStr(inter);
                baseInterface.setInter(interface_);
                String entityClassName = this.getEntityClassName(interfaceName, interface_.getName());
                Class<?> entityClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(entityClassName);
                baseInterface.setEntityClass(entityClass);
                result.add(baseInterface);
            }
        }
        catch (Exception e) {
            throw new MagicException(e);
        }
        return result;
    }

    private String getEntityClassName(String name, String interfaceName) {
        if (!name.endsWith(">")) {
            throw new IllegalStateException("BaseMapper\u5fc5\u987b\u8bbe\u7f6e\u597d\u6620\u5c04\u6cdb\u578b\u5b9e\u4f53\u7c7b\uff0c\u4f8b\u5982\uff1aUserMapper extends BaseMapper<UserEntity>\uff0c\u5f53\u524d\u63a5\u53e3\uff1a" + interfaceName);
        }
        String substring = name.substring(31);
        return substring.substring(0, substring.length() - 1);
    }

    private String getBaseMapperInterfaceName(Type[] genericInterfaces) {
        for (Type name : genericInterfaces) {
            if (!name.getTypeName().startsWith("top.lingkang.mm.orm.BaseMapper")) continue;
            return name.getTypeName();
        }
        return null;
    }
}

