/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import top.lingkang.mm.MagicConfiguration;
import top.lingkang.mm.annotation.Column;
import top.lingkang.mm.annotation.Id;
import top.lingkang.mm.annotation.IgnoreColumn;
import top.lingkang.mm.annotation.PostUpdate;
import top.lingkang.mm.annotation.PreUpdate;
import top.lingkang.mm.annotation.Table;
import top.lingkang.mm.constant.IdType;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.gen.IdGenerate;
import top.lingkang.mm.orm.MagicEntity;
import top.lingkang.mm.utils.MagicUtils;

class MagicEntityUtils {
    private static final Map<Class<?>, MagicEntity> cache = new HashMap();

    MagicEntityUtils() {
    }

    public static MagicEntity getMagicEntity(Configuration configuration, Class<?> clazz) {
        MagicEntity entity = cache.get(clazz);
        if (entity != null) {
            return entity;
        }
        Table table = clazz.getAnnotation(Table.class);
        Assert.notNull((Object)table, (String)("\u5b9e\u4f53\u7c7b " + clazz.getName() + " \u6ca1\u6709 @Table \u6ce8\u89e3"), (Object[])new Object[0]);
        entity = new MagicEntity();
        entity.setClazz(clazz);
        entity.setTableName(StrUtil.isNotEmpty((CharSequence)table.value()) ? table.value() : clazz.getSimpleName());
        for (Method method : MagicUtils.getAllPublicMethod(clazz)) {
            if (method.isAnnotationPresent(PostUpdate.class)) {
                if (entity.getPostUpdate() == null) {
                    entity.setPostUpdate(new ArrayList<Method>());
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                entity.getPostUpdate().add(method);
                continue;
            }
            if (!method.isAnnotationPresent(PreUpdate.class)) continue;
            if (entity.getPreUpdate() == null) {
                entity.setPreUpdate(new ArrayList<Method>());
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            entity.getPreUpdate().add(method);
        }
        int i = 0;
        for (Field field : MagicUtils.getAllField(clazz)) {
            if (field.isAnnotationPresent(IgnoreColumn.class)) continue;
            Id id = field.getAnnotation(Id.class);
            if (id != null) {
                if (entity.getIdAnn() != null) {
                    throw new MagicException("\u5df2\u7ecf\u5b58\u5728\u91cd\u590d @Id \u6ce8\u89e3\uff1a" + entity.getIdAnn().annotationType().getName());
                }
                entity.setIdAnn(field.getAnnotation(Id.class));
                entity.setIdIndex(i);
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            entity.getFields().add(field);
            Column column = field.getAnnotation(Column.class);
            if (column != null && StrUtil.isNotEmpty((CharSequence)column.value())) {
                entity.getColumnName().add(column.value());
            } else if (configuration.isMapUnderscoreToCamelCase()) {
                entity.getColumnName().add(StrUtil.toUnderlineCase((CharSequence)field.getName()));
            } else {
                entity.getColumnName().add(field.getName());
            }
            ++i;
        }
        Assert.isFalse((boolean)entity.getColumnName().isEmpty(), (String)("\u5b9e\u4f53\u6620\u5c04\u6ca1\u6709\u67e5\u8be2\u5217\u5c5e\u6027: " + clazz.getName()), (Object[])new Object[0]);
        cache.put(clazz, entity);
        String columns_ = MagicEntityUtils.getColumns(entity.getColumnName(), null);
        entity.setSelectTableSql("select " + columns_ + " from " + entity.getTableName() + " ");
        return entity;
    }

    public static String getColumns(List<String> col, String prefix) {
        StringBuilder res = new StringBuilder();
        if ("".equals(prefix)) {
            prefix = null;
        }
        for (int i = 0; i < col.size(); ++i) {
            if (prefix != null) {
                res.append(prefix).append(".").append(col.get(i));
            } else {
                res.append(col.get(i));
            }
            if (i >= col.size() - 1) continue;
            res.append(", ");
        }
        return res.toString();
    }

    public static String getInsertValues(MagicEntity entity, String prefix) {
        List<String> col = entity.getColumnName();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < col.size(); ++i) {
            if (prefix != null) {
                res.append("#{").append(prefix).append(".").append(col.get(i)).append("}");
            } else {
                res.append("#{").append(col.get(i)).append("}");
            }
            if (i >= col.size() - 1) continue;
            res.append(",");
        }
        return res.toString();
    }

    public static void setIdValue(Object obj, Configuration configuration, MagicEntity entity) throws IllegalAccessException {
        if (entity.getIdAnn().value() == IdType.ASSIGN) {
            Field field = entity.getFields().get(entity.getIdIndex());
            if (field.get(obj) != null) {
                return;
            }
            IdGenerate idGenerate = MagicConfiguration.idGenerate;
            if (configuration instanceof MagicConfiguration) {
                idGenerate = ((MagicConfiguration)configuration).getIdGenerate();
            }
            Object id = idGenerate.nextId(entity.getIdAnn().assignParam());
            if (field.getType() != id.getClass()) {
                throw new MagicException("id: IdType.ASSIGN\u3002\u5b9e\u4f53" + entity.getClazz().getName() + "\u7684 " + field.getName() + " \u5c5e\u6027\u7c7b\u578b\uff1a" + field.getType().getName() + "  idGenerate \u81ea\u52a8\u751f\u6210\u7684id\u7c7b\u578b: " + id.getClass().getName() + " \u7c7b\u578b\u4e0d\u4e00\u81f4\u5bfc\u81f4\u81ea\u52a8\u751f\u6210id\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 idGenerate \u8fd4\u56de\u7c7b\u578b\u4e0e\u5b9e\u4f53id\u7c7b\u578b\u662f\u5426\u4e00\u81f4");
            }
            field.set(obj, id);
        }
    }

    public static Map<String, Object> getInsertNotNullParams(Object obj, MagicEntity entity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        boolean isSequence = false;
        if (entity.getIdAnn() != null && entity.getIdAnn().value() == IdType.AUTO && StrUtil.isNotEmpty((CharSequence)entity.getIdAnn().sequence())) {
            isSequence = true;
        }
        for (int i = 0; i < entity.getColumnName().size(); ++i) {
            try {
                Field field = entity.getFields().get(i);
                Object value = field.get(obj);
                if (isSequence && value == null) {
                    if (entity.getColumnName().size() == 1) {
                        throw new MagicException("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u63d2\u5165\u7684\u8868\u5217\u5fc5\u987b\u5927\u4e8e1: " + obj);
                    }
                    columns.append(entity.getColumnName().get(i)).append(", ");
                    values.append("nextval('").append(entity.getIdAnn().sequence()).append("'), ");
                    continue;
                }
                if (value == null) continue;
                columns.append(entity.getColumnName().get(i)).append(", ");
                values.append("#{e.").append(entity.getFields().get(i).getName()).append("}, ");
                continue;
            }
            catch (Exception e) {
                throw new MagicException(e);
            }
        }
        if (columns.length() == 0) {
            throw new MagicException("\u4e0d\u80fd\u63d2\u5165\u5168\u7a7a\u503c\uff1a" + obj);
        }
        param.put("columns", columns.substring(0, columns.length() - 2));
        param.put("values", values.substring(0, values.length() - 2));
        param.put("e", obj);
        return param;
    }

    public static Map<String, Object> getInsertNotNullBaseMapper(Object obj, MagicEntity entity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        boolean isSequence = false;
        if (entity.getIdAnn() != null && entity.getIdAnn().value() == IdType.AUTO && StrUtil.isNotEmpty((CharSequence)entity.getIdAnn().sequence())) {
            isSequence = true;
        }
        for (int i = 0; i < entity.getColumnName().size(); ++i) {
            try {
                Field field = entity.getFields().get(i);
                Object value = field.get(obj);
                if (isSequence && value == null) {
                    if (entity.getColumnName().size() == 1) {
                        throw new MagicException("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u63d2\u5165\u7684\u8868\u5217\u5fc5\u987b\u5927\u4e8e1: " + obj);
                    }
                    columns.append(entity.getColumnName().get(i)).append(", ");
                    values.append("nextval('").append(entity.getIdAnn().sequence()).append("'), ");
                    continue;
                }
                if (value == null) continue;
                columns.append(entity.getColumnName().get(i)).append(", ");
                values.append("?");
                continue;
            }
            catch (Exception e) {
                throw new MagicException(e);
            }
        }
        if (columns.length() == 0) {
            throw new MagicException("\u4e0d\u80fd\u63d2\u5165\u5168\u7a7a\u503c\uff1a" + obj);
        }
        param.put("columns", columns.substring(0, columns.length() - 2));
        param.put("values", values.substring(0, values.length() - 2));
        param.put("e", obj);
        return param;
    }

    public static String getOrderBy(String[] cols) {
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < cols.length; ++i) {
            sql.append(cols[i]);
            if (i >= cols.length - 1) continue;
            sql.append(", ");
        }
        return sql.toString();
    }

    public static String getOrderBy(String[] cols, String by) {
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < cols.length; ++i) {
            sql.append(cols[i]).append(" ").append(by);
            if (i >= cols.length - 1) continue;
            sql.append(", ");
        }
        return sql.toString();
    }

    public static void execPreUpdate(MagicEntity entity, Object obj) {
        if (entity.getPreUpdate() == null) {
            return;
        }
        for (Method method : entity.getPreUpdate()) {
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new MagicException("\u8c03\u7528 @PreUpdate \u5f02\u5e38: " + entity.getClazz().getName(), e);
            }
        }
    }

    public static void execPostUpdate(MagicEntity entity, Object obj) {
        if (entity.getPostUpdate() == null) {
            return;
        }
        for (Method method : entity.getPostUpdate()) {
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new MagicException("\u8c03\u7528 @PostUpdate \u5f02\u5e38: " + entity.getClazz().getName(), e);
            }
        }
    }

    public static String getSetColumns(MagicEntity entity, String prefix) {
        if ("".equals(prefix)) {
            prefix = null;
        }
        List<String> col = entity.getColumnName();
        List<Field> fields = entity.getFields();
        StringBuilder set = new StringBuilder();
        for (int i = 0; i < col.size(); ++i) {
            if (prefix != null) {
                set.append(col.get(i)).append("=#{").append(prefix).append(".").append(fields.get(i).getName()).append("}");
            } else {
                set.append(col.get(i)).append("=#{").append(fields.get(i).getName()).append("}");
            }
            if (i >= col.size() - 1) continue;
            set.append(", ");
        }
        return set.toString();
    }

    public static String getInsertPrefixValues(MagicEntity entity, String prefix) {
        if ("".equals(prefix)) {
            prefix = null;
        }
        boolean isSequence = false;
        if (entity.getIdAnn() != null && entity.getIdAnn().value() == IdType.AUTO && StrUtil.isNotEmpty((CharSequence)entity.getIdAnn().sequence())) {
            isSequence = true;
        }
        List<String> col = entity.getColumnName();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < col.size(); ++i) {
            if (isSequence && i == entity.getIdIndex()) {
                res.append("nextval('").append(entity.getIdAnn().sequence()).append("')");
            } else if (prefix != null) {
                res.append("#{").append(prefix).append(".").append(col.get(i)).append("}");
            } else {
                res.append("#{").append(col.get(i)).append("}");
            }
            if (i >= col.size() - 1) continue;
            res.append(",");
        }
        return res.toString();
    }

    public static void execPreUpdateList(MagicEntity entity, List list) {
        if (entity.getPreUpdate() == null) {
            return;
        }
        for (Method method : entity.getPreUpdate()) {
            try {
                for (Object o : list) {
                    method.invoke(o, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new MagicException("\u8c03\u7528 @PreUpdate \u5f02\u5e38: " + entity.getClazz().getName(), e);
            }
        }
    }

    public static void execPostUpdateList(MagicEntity entity, List list) {
        if (entity.getPostUpdate() == null) {
            return;
        }
        for (Method method : entity.getPostUpdate()) {
            try {
                for (Object o : list) {
                    method.invoke(o, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new MagicException("\u8c03\u7528 @PostUpdate \u5f02\u5e38: " + entity.getClazz().getName(), e);
            }
        }
    }
}

