/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import cn.hutool.core.lang.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.orm.Condition;
import top.lingkang.mm.orm.ConditionOrderBy;
import top.lingkang.mm.orm.ConditionValue;
import top.lingkang.mm.orm.MagicEntityUtils;

public class Query {
    protected List<ConditionValue> list = new ArrayList<ConditionValue>();
    protected List<ConditionOrderBy> orderBy;
    protected String sql = "where 1=1";
    protected HashMap<String, Object> param = new HashMap();

    public Query eq(String column, Object value) {
        this.list.add(new ConditionValue(Condition.eq, column, value));
        return this;
    }

    public Query ne(String column, Object value) {
        this.list.add(new ConditionValue(Condition.ne, column, value));
        return this;
    }

    public Query gt(String column, Object value) {
        this.list.add(new ConditionValue(Condition.gt, column, value));
        return this;
    }

    public Query ge(String column, Object value) {
        this.list.add(new ConditionValue(Condition.ge, column, value));
        return this;
    }

    public Query lt(String column, Object value) {
        this.list.add(new ConditionValue(Condition.lt, column, value));
        return this;
    }

    public Query le(String column, Object value) {
        this.list.add(new ConditionValue(Condition.le, column, value));
        return this;
    }

    public Query like(String column, Object value) {
        this.list.add(new ConditionValue(Condition.like, column, value));
        return this;
    }

    public Query notLike(String column, Object value) {
        this.list.add(new ConditionValue(Condition.notLike, column, value));
        return this;
    }

    public Query likeLeft(String column, Object value) {
        this.list.add(new ConditionValue(Condition.likeLeft, column, value));
        return this;
    }

    public Query likeRight(String column, Object value) {
        this.list.add(new ConditionValue(Condition.likeRight, column, value));
        return this;
    }

    public Query notLikeLeft(String column, Object value) {
        this.list.add(new ConditionValue(Condition.notLikeLeft, column, value));
        return this;
    }

    public Query notLikeRight(String column, Object value) {
        this.list.add(new ConditionValue(Condition.notLikeRight, column, value));
        return this;
    }

    public Query isNull(String column, Object value) {
        this.list.add(new ConditionValue(Condition.isNull, column, value));
        return this;
    }

    public Query isNotNull(String column, Object value) {
        this.list.add(new ConditionValue(Condition.isNotNull, column, value));
        return this;
    }

    public Query in(String column, Collection value) {
        this.list.add(new ConditionValue(Condition.in, column, value));
        return this;
    }

    public Query notIn(String column, Collection value) {
        this.list.add(new ConditionValue(Condition.notIn, column, value));
        return this;
    }

    public Query orderByAsc(String ... ascColumn) {
        Assert.notNull((Object)ascColumn, (String)"\u6392\u5e8f\u7684\u5217\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<ConditionOrderBy>();
        }
        this.orderBy.add(new ConditionOrderBy(Condition.orderByAsc, ascColumn));
        return this;
    }

    public Query orderByDesc(String ... descColumn) {
        Assert.notNull((Object)descColumn, (String)"\u6392\u5e8f\u7684\u5217\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<ConditionOrderBy>();
        }
        this.orderBy.add(new ConditionOrderBy(Condition.orderByDesc, descColumn));
        return this;
    }

    public Query or() {
        this.list.add(new ConditionValue(Condition.or));
        return this;
    }

    public Query sql(String sql) {
        this.list.add(new ConditionValue(Condition.sql, sql, null));
        return this;
    }

    public Query sql(String sql, Map<String, Object> param) {
        this.list.add(new ConditionValue(Condition.sql, sql, param));
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        boolean isOr = false;
        int i = 1;
        for (ConditionValue conditionValue : this.list) {
            String name;
            int j;
            Collection collection;
            Condition key = conditionValue.getCondition();
            if (key == Condition.or) {
                sql.append(" or ");
                isOr = true;
                continue;
            }
            if (!isOr) {
                sql.append(" and ");
            } else {
                isOr = false;
            }
            Object value = conditionValue.getValue();
            String column = conditionValue.getColumn();
            String p = "p" + i++;
            if (key == Condition.eq) {
                sql.append(column).append("= ");
                this.addQueryParam(sql, p);
                this.param.put(p, value);
                continue;
            }
            if (key == Condition.ne) {
                sql.append(column).append("<> ");
                this.addQueryParam(sql, p);
                this.param.put(p, value);
                continue;
            }
            if (key == Condition.gt) {
                sql.append(column).append("> ");
                this.addQueryParam(sql, p);
                this.param.put(p, value);
                continue;
            }
            if (key == Condition.ge) {
                sql.append(column).append(">= ");
                this.addQueryParam(sql, p);
                this.param.put(p, value);
                continue;
            }
            if (key == Condition.lt) {
                sql.append(column).append("< ");
                this.addQueryParam(sql, p);
                this.param.put(p, value);
                continue;
            }
            if (key == Condition.le) {
                sql.append(column).append("<= ");
                this.addQueryParam(sql, p);
                this.param.put(p, value);
                continue;
            }
            if (key == Condition.like) {
                sql.append(column).append(" like ");
                this.addQueryParam(sql, p);
                this.param.put(p, "%" + value + "%");
                continue;
            }
            if (key == Condition.notLike) {
                sql.append(column).append(" not like ");
                this.addQueryParam(sql, p);
                this.param.put(p, "%" + value + "%");
                continue;
            }
            if (key == Condition.likeLeft) {
                sql.append(column).append(" like ");
                this.addQueryParam(sql, p);
                this.param.put(p, "%" + value);
                continue;
            }
            if (key == Condition.likeRight) {
                sql.append(column).append(" like ");
                this.addQueryParam(sql, p);
                this.param.put(p, value + "%");
                continue;
            }
            if (key == Condition.notLikeLeft) {
                sql.append(column).append(" not like ");
                this.addQueryParam(sql, p);
                this.param.put(p, "%" + value);
                continue;
            }
            if (key == Condition.notLikeRight) {
                sql.append(column).append(" not like ");
                this.addQueryParam(sql, p);
                this.param.put(p, value + "%");
                continue;
            }
            if (key == Condition.isNull) {
                sql.append(column).append(" is null");
                continue;
            }
            if (key == Condition.isNotNull) {
                sql.append(column).append(" is not null");
                continue;
            }
            if (key == Condition.in) {
                if (value != null) {
                    collection = (Collection)value;
                    if (collection.isEmpty()) {
                        throw new MagicException("\u67e5\u8be2\u6761\u4ef6: in \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    sql.append(column).append(" in (");
                    j = 1;
                    for (Object o : collection) {
                        name = p + "_" + j;
                        this.addQueryParam(sql, name);
                        this.param.put(name, o);
                        if (j < collection.size()) {
                            sql.append(",");
                        }
                        ++j;
                    }
                    sql.append(")");
                    continue;
                }
                throw new MagicException("in \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (key == Condition.notIn) {
                if (value != null) {
                    collection = (Collection)value;
                    if (collection.isEmpty()) {
                        throw new MagicException("\u67e5\u8be2\u6761\u4ef6: notIn \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    sql.append(column).append(" not in (");
                    j = 1;
                    for (Object o : collection) {
                        name = p + "_" + j;
                        this.addQueryParam(sql, name);
                        this.param.put(name, o);
                        if (j < collection.size()) {
                            sql.append(",");
                        }
                        ++j;
                    }
                    sql.append(")");
                    continue;
                }
                throw new MagicException("notIn \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (key != Condition.sql) continue;
            sql.append(" ").append(column);
            if (value == null) continue;
            this.param.putAll((Map)value);
        }
        if (this.orderBy != null) {
            boolean has = false;
            for (ConditionOrderBy by : this.orderBy) {
                if (by.getColumns() == null || by.getColumns().length == 0) {
                    throw new MagicException("orderBy \u6392\u5e8f\u5217\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!has) {
                    sql.append(" order by ");
                } else {
                    sql.append(", ");
                }
                if (by.getBy() == Condition.orderByAsc) {
                    if (!has) {
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns())).append(" asc");
                    } else {
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns(), "asc"));
                    }
                } else if (by.getBy() == Condition.orderByDesc) {
                    if (!has) {
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns())).append(" desc");
                    } else {
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns(), "desc"));
                    }
                }
                has = true;
            }
        }
        return sql.toString();
    }

    protected void addQueryParam(StringBuilder sql, String p) {
        sql.append("#{q.param.").append(p).append("}");
    }

    public String getSql() {
        if (this.list.isEmpty() && this.orderBy == null) {
            return "";
        }
        return this.sql + this.buildSql();
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public HashMap<String, Object> getParam() {
        return this.param;
    }

    public void setParam(HashMap<String, Object> param) {
        this.param = param;
    }
}

