/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.page;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.page.PageHelper;
import top.lingkang.mm.page.PageInfo;
import top.lingkang.mm.page.PageSqlHandle;
import top.lingkang.mm.page.PageSqlInfo;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class MagicPageInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MagicPageInterceptor.class);
    private Field sqlField;

    public MagicPageInterceptor() {
        try {
            this.sqlField = BoundSql.class.getDeclaredField("sql");
            this.sqlField.setAccessible(true);
        }
        catch (Exception e) {
            throw new MagicException(e);
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        PageInfo page = PageHelper.getPage();
        if (page == null || page.isComplete()) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        if (!boundSql.getSql().toLowerCase().startsWith("select")) {
            log.warn("\u542f\u7528\u5206\u9875\u67e5\u8be2\u540e\uff0c\u6267\u884c\u7684sql\u4e0d\u662f\u67e5\u8be2sql: " + boundSql.getSql());
            return invocation.proceed();
        }
        Connection conn = (Connection)invocation.getArgs()[0];
        PageSqlHandle pageSqlHandle = PageHelper.getHandle(conn);
        PageSqlInfo sqlInfo = pageSqlHandle.handleSql(boundSql.getSql(), page.getPage(), page.getSize());
        PreparedStatement statement = conn.prepareStatement(sqlInfo.getCountSql());
        pageSqlHandle.handleParams(boundSql, statement);
        ResultSet resultSet = statement.executeQuery();
        if (resultSet.next()) {
            long total = resultSet.getLong(1);
            page.setTotal(total);
            page.setComplete(true);
            resultSet.close();
        }
        if (page.getTotal() > 0L) {
            this.sqlField.set(boundSql, sqlInfo.getSelectSql());
        }
        return invocation.proceed();
    }
}

