/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.List;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.orm.BaseMapperManage;
import top.lingkang.mm.orm.MagicEntity;
import top.lingkang.mm.orm.MagicEntityUtils;
import top.lingkang.mm.orm.MapperManage;
import top.lingkang.mm.orm.QueryWrapper;
import top.lingkang.mm.orm.UpadateWrapper;
import top.lingkang.mm.utils.MagicUtils;

public class MapperManageImpl
extends BaseMapperManage
implements MapperManage {
    public MapperManageImpl(Configuration configuration, SqlSession sqlSession) {
        super(configuration, sqlSession);
    }

    @Override
    public <T> QueryWrapper<T> createQuery(String sql, Class<T> resultClass) {
        return new QueryWrapper<T>(sql, resultClass, this);
    }

    @Override
    public UpadateWrapper createUpdate(String sql) {
        return new UpadateWrapper(sql, this);
    }

    @Override
    public <T> List<T> selectAll(Class<T> entityClass) {
        String sqlId = this.getSqlId((Class)entityClass, "selectAll");
        return this.sqlSession.selectList(sqlId);
    }

    @Override
    public <T> T selectById(Class<T> entityClass, Object id) {
        MagicEntity entity = this.getMagicEntity((Class)entityClass);
        if (entity.getIdIndex() == -1) {
            throw new MagicException("\u5b9e\u4f53\u5bf9\u8c61\u6ca1\u6709 @Id \u6ce8\u89e3: " + entityClass.getName());
        }
        String sqlId = this.getSqlId(entity, "selectById");
        return (T)this.sqlSession.selectOne(sqlId, id);
    }

    @Override
    public <T> boolean existsById(Class<T> entityClass, Object id) {
        MagicEntity entity = this.getMagicEntity((Class)entityClass);
        if (entity.getIdIndex() == -1) {
            throw new MagicException("\u5b9e\u4f53\u5bf9\u8c61\u6ca1\u6709 @Id \u6ce8\u89e3: " + entityClass.getName());
        }
        String sqlId = this.getSqlId(entity, "existsById");
        return (Boolean)this.sqlSession.selectOne(sqlId, id);
    }

    @Override
    public int insert(Object entity) {
        return this.insert(entity, true);
    }

    @Override
    public int insert(Object entity, boolean insertNull) {
        Assert.notNull((Object)entity, (String)"\u63d2\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MagicEntity magicEntity = this.getMagicEntity((Class)entity.getClass());
        this.checkIdSet(magicEntity, entity, this.getIdGenerate());
        MagicEntityUtils.execPreUpdate(magicEntity, entity);
        int result = insertNull ? this.sqlSession.insert(this.getSqlId(magicEntity, "insert"), entity) : this.sqlSession.insert(this.getSqlId(magicEntity, "notInsertNull"), MagicEntityUtils.getInsertNotNullParams(entity, magicEntity));
        MagicEntityUtils.execPostUpdate(magicEntity, entity);
        return result;
    }

    @Override
    public <T> int insertBatch(List<T> list) {
        if (list == null || list.isEmpty()) {
            throw new MagicException("\u63d2\u5165\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u7a7a");
        }
        MagicEntity magicEntity = this.getMagicEntity((Class)list.get(0).getClass());
        if (magicEntity.getIdIndex() == -1) {
            throw new MagicException("\u66f4\u65b0\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + magicEntity.getClazz().getName());
        }
        MagicEntityUtils.execPreUpdateList(magicEntity, list);
        int result = this.sqlSession.insert(this.getSqlId(magicEntity, "insertList"), list);
        MagicEntityUtils.execPostUpdateList(magicEntity, list);
        return result;
    }

    @Override
    public int updateById(Object entity) {
        return this.updateById(entity, true);
    }

    @Override
    public int updateById(Object entity, boolean updateNull) {
        Assert.isFalse((boolean)(entity instanceof Class), (String)("\u66f4\u65b0\u7684\u6570\u636e\u7c7b\u578b\u9519\u8bef: " + entity), (Object[])new Object[0]);
        MagicEntity magicEntity = this.getMagicEntity((Class)entity.getClass());
        if (magicEntity.getIdIndex() == -1) {
            throw new MagicException("\u66f4\u65b0\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + magicEntity.getClazz().getName());
        }
        MagicEntityUtils.execPreUpdate(magicEntity, entity);
        int result = updateNull ? this.sqlSession.update(this.getSqlId(magicEntity, "updateById"), entity) : this.sqlSession.update(this.getSqlId(magicEntity, "updateNotNullById"), (Object)this.getUpdateNotNullParams(entity, magicEntity));
        MagicEntityUtils.execPostUpdate(magicEntity, entity);
        return result;
    }

    @Override
    public int deleteById(Object entity) {
        Assert.isFalse((boolean)(entity instanceof Class), (String)("\u66f4\u65b0\u7684\u6570\u636e\u7c7b\u578b\u9519\u8bef: " + entity), (Object[])new Object[0]);
        MagicEntity magicEntity = this.getMagicEntity((Class)entity.getClass());
        if (magicEntity.getIdIndex() == -1) {
            throw new MagicException("\u66f4\u65b0\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + magicEntity.getClazz().getName());
        }
        Object idValue = this.getIdValue(entity, magicEntity.getClazz(), magicEntity.getFields().get(magicEntity.getIdIndex()).getName());
        if (idValue == null) {
            throw new MagicException("\u5b9e\u4f53\u5bf9\u8c61\u7684id\u4e0d\u80fd\u4e3a\u7a7a: " + entity);
        }
        MagicEntityUtils.execPreUpdate(magicEntity, entity);
        int result = this.sqlSession.delete(this.getSqlId(magicEntity, "deleteById"), idValue);
        MagicEntityUtils.execPostUpdate(magicEntity, entity);
        return result;
    }

    @Override
    public int deleteById(Class<?> entityClass, Object id) {
        if (id == null) {
            throw new MagicException("\u5b9e\u4f53\u5bf9\u8c61\u7684id\u4e0d\u80fd\u4e3a\u7a7a: " + entityClass.getName());
        }
        MagicEntity magicEntity = this.getMagicEntity((Class)entityClass);
        if (magicEntity.getIdIndex() == -1) {
            throw new MagicException("\u66f4\u65b0\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + magicEntity.getClazz().getName());
        }
        return this.sqlSession.delete(this.getSqlId(magicEntity, "deleteById"), id);
    }

    @Override
    public <T, E> int deleteByIds(Class<T> entityClass, List<E> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new MagicException("\u5b9e\u4f53\u5bf9\u8c61\u7684ids\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a: " + entityClass.getName());
        }
        ids.forEach(o -> {
            if (o == null) {
                throw new MagicException("\u5b9e\u4f53\u5bf9\u8c61\u7684ids\u96c6\u5408\u5b58\u5728\u7a7a\u503c\uff1a" + ids);
            }
        });
        MagicEntity magicEntity = this.getMagicEntity((Class)entityClass);
        if (magicEntity.getIdIndex() == -1) {
            throw new MagicException("\u66f4\u65b0\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + magicEntity.getClazz().getName());
        }
        return this.sqlSession.delete(this.getSqlId(magicEntity, "deleteByIds"), ids);
    }

    @Override
    public <T> T getMapper(Class<T> type) {
        return (T)this.configuration.getMapper(type, this.sqlSession);
    }

    @Override
    public <T> String selectTableSql(Class<T> entityClass) {
        MagicEntity magicEntity = this.getMagicEntity((Class)entityClass);
        return magicEntity.getSelectTableSql();
    }

    @Override
    public void executeSqlScript(String sqlScript) {
        Connection connection = this.sqlSession.getConnection();
        MagicUtils.exeScript(sqlScript, connection);
    }

    @Override
    public void executeSqlScript(File scriptFile) {
        if (scriptFile == null) {
            throw new MagicException("sql\u811a\u672c\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (!scriptFile.exists()) {
            throw new MagicException("sql\u811a\u672c\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + scriptFile.getAbsolutePath());
        }
        this.executeSqlScript(FileUtil.readString((File)scriptFile, (Charset)StandardCharsets.UTF_8));
    }
}

