/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.error.MagicException;

public final class TransactionManage {
    private static final Logger log = LoggerFactory.getLogger(TransactionManage.class);
    private static final ThreadLocal<Connection> tm = new ThreadLocal();
    private static final ThreadLocal<Boolean> openTran = ThreadLocal.withInitial(() -> false);

    public static Connection getConnection(DataSource dataSource) throws SQLException {
        Connection connection = tm.get();
        if (connection != null) {
            return connection;
        }
        if (openTran.get().booleanValue()) {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
            tm.set(connection);
            return connection;
        }
        return dataSource.getConnection();
    }

    public static void beginTransaction() {
        if (openTran.get().booleanValue()) {
            log.warn("\u4e8b\u52a1\u5df2\u7ecf\u5f00\u542f\u4e86");
            return;
        }
        openTran.set(true);
        log.debug("\u542f\u7528\u4e8b\u52a1");
    }

    public static boolean isTransaction() {
        return openTran.get();
    }

    public static void commit() {
        if (!TransactionManage.isTransaction()) {
            return;
        }
        Connection connection = tm.get();
        if (connection == null) {
            openTran.set(false);
            return;
        }
        try {
            connection.commit();
            connection.close();
            log.debug("\u63d0\u4ea4\u4e8b\u52a1\u6210\u529f");
            tm.remove();
            openTran.set(false);
            log.debug("\u5173\u95ed\u8fde\u63a5");
        }
        catch (SQLException e) {
            throw new MagicException("\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25", e);
        }
    }

    public static void rollback() {
        if (!TransactionManage.isTransaction()) {
            return;
        }
        Connection connection = tm.get();
        if (connection == null) {
            openTran.set(false);
            return;
        }
        try {
            connection.rollback();
            connection.close();
            log.debug("\u56de\u6eda\u4e8b\u52a1\u6210\u529f");
            tm.remove();
            openTran.set(false);
            log.debug("\u5173\u95ed\u8fde\u63a5");
        }
        catch (SQLException e) {
            throw new MagicException("\u63d0\u4ea4\u4e8b\u52a1\u5931\u8d25", e);
        }
    }
}

