package top.lingkang.mm.orm;

import cn.hutool.core.lang.Assert;
import top.lingkang.mm.error.MagicException;

import java.util.*;

/**
 * @author lingkang
 * @create by 2024/3/12 16:13
 */
public class Query {
    protected List<ConditionValue> list = new ArrayList<>();
    protected List<ConditionOrderBy> orderBy;
    protected String sql = "where 1=1";
    protected HashMap<String, Object> param = new HashMap<>();

    public Query eq(String column, Object value) {
        list.add(new ConditionValue(Condition.eq, column, value));
        return this;
    }

    public Query ne(String column, Object value) {
        list.add(new ConditionValue(Condition.ne, column, value));
        return this;
    }

    public Query gt(String column, Object value) {
        list.add(new ConditionValue(Condition.gt, column, value));
        return this;
    }

    public Query ge(String column, Object value) {
        list.add(new ConditionValue(Condition.ge, column, value));
        return this;
    }

    public Query lt(String column, Object value) {
        list.add(new ConditionValue(Condition.lt, column, value));
        return this;
    }

    public Query le(String column, Object value) {
        list.add(new ConditionValue(Condition.le, column, value));
        return this;
    }

    public Query like(String column, Object value) {
        list.add(new ConditionValue(Condition.like, column, value));
        return this;
    }

    public Query notLike(String column, Object value) {
        list.add(new ConditionValue(Condition.notLike, column, value));
        return this;
    }

    public Query likeLeft(String column, Object value) {
        list.add(new ConditionValue(Condition.likeLeft, column, value));
        return this;
    }

    public Query likeRight(String column, Object value) {
        list.add(new ConditionValue(Condition.likeRight, column, value));
        return this;
    }

    public Query notLikeLeft(String column, Object value) {
        list.add(new ConditionValue(Condition.notLikeLeft, column, value));
        return this;
    }

    public Query notLikeRight(String column, Object value) {
        list.add(new ConditionValue(Condition.notLikeRight, column, value));
        return this;
    }

    public Query isNull(String column, Object value) {
        list.add(new ConditionValue(Condition.isNull, column, value));
        return this;
    }

    public Query isNotNull(String column, Object value) {
        list.add(new ConditionValue(Condition.isNotNull, column, value));
        return this;
    }

    public Query in(String column, Collection value) {
        list.add(new ConditionValue(Condition.in, column, value));
        return this;
    }

    public Query notIn(String column, Collection value) {
        list.add(new ConditionValue(Condition.notIn, column, value));
        return this;
    }

    public Query orderByAsc(String... ascColumn) {
        Assert.notNull(ascColumn, "排序的列不能为空");
        if (orderBy == null)
            orderBy = new ArrayList<>();
        orderBy.add(new ConditionOrderBy(Condition.orderByAsc, ascColumn));
        return this;
    }

    public Query orderByDesc(String... descColumn) {
        Assert.notNull(descColumn, "排序的列不能为空");
        if (orderBy == null)
            orderBy = new ArrayList<>();
        orderBy.add(new ConditionOrderBy(Condition.orderByDesc, descColumn));
        return this;
    }

    public Query or() {
        list.add(new ConditionValue(Condition.or));
        return this;
    }

    public Query sql(String sql) {
        list.add(new ConditionValue(Condition.sql, sql, null));
        return this;
    }

    public Query sql(String sql, Map<String, Object> param) {
        list.add(new ConditionValue(Condition.sql, sql, param));
        return this;
    }

    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        // List<Object> params = new ArrayList<>();
        boolean isOr = false;
        int i = 1;
        for (ConditionValue conditionValue : list) {
            Condition key = conditionValue.getCondition();
            if (key == Condition.or) {
                sql.append(" or ");
                isOr = true;
                continue;
            }
            if (!isOr)
                sql.append(" and ");
            else
                isOr = false;

            // 条件
            Object value = conditionValue.getValue();
            String column = conditionValue.getColumn();
            String p = "p" + i++;
            if (key == Condition.eq) {
                sql.append(column).append("= ");
                addQueryParam(sql, p);
                param.put(p, value);
            } else if (key == Condition.ne) {
                sql.append(column).append("<> ");
                addQueryParam(sql, p);
                param.put(p, value);
            } else if (key == Condition.gt) {
                sql.append(column).append("> ");
                addQueryParam(sql, p);
                param.put(p, value);
            } else if (key == Condition.ge) {
                sql.append(column).append(">= ");
                addQueryParam(sql, p);
                param.put(p, value);
            } else if (key == Condition.lt) {
                sql.append(column).append("< ");
                addQueryParam(sql, p);
                param.put(p, value);
            } else if (key == Condition.le) {
                sql.append(column).append("<= ");
                addQueryParam(sql, p);
                param.put(p, value);
            } else if (key == Condition.like) {
                sql.append(column).append(" like ");
                addQueryParam(sql, p);
                param.put(p, "%" + value + "%");
            } else if (key == Condition.notLike) {
                sql.append(column).append(" not like ");
                addQueryParam(sql, p);
                param.put(p, "%" + value + "%");
            } else if (key == Condition.likeLeft) {
                sql.append(column).append(" like ");
                addQueryParam(sql, p);
                param.put(p, "%" + value);
            } else if (key == Condition.likeRight) {
                sql.append(column).append(" like ");
                addQueryParam(sql, p);
                param.put(p, value + "%");
            } else if (key == Condition.notLikeLeft) {
                sql.append(column).append(" not like ");
                addQueryParam(sql, p);
                param.put(p, "%" + value);
            } else if (key == Condition.notLikeRight) {
                sql.append(column).append(" not like ");
                addQueryParam(sql, p);
                param.put(p, value + "%");
            } else if (key == Condition.isNull) {
                sql.append(column).append(" is null");
            } else if (key == Condition.isNotNull) {
                sql.append(column).append(" is not null");
            } else if (key == Condition.in) {
                if (value != null) {
                    Collection collection = (Collection) value;
                    if (collection.isEmpty())
                        throw new MagicException("查询条件: in 入参不能为空！");
                    sql.append(column).append(" in (");
                    int j = 1;
                    for (Object o : collection) {
                        String name = p + "_" + j;
                        addQueryParam(sql, name);
                        param.put(name, o);
                        if (j < collection.size())
                            sql.append(",");
                        j++;
                    }
                    sql.append(")");
                } else
                    throw new MagicException("in 入参不能为空！");
            } else if (key == Condition.notIn) {
                if (value != null) {
                    Collection collection = (Collection) value;
                    if (collection.isEmpty())
                        throw new MagicException("查询条件: notIn 入参不能为空！");
                    sql.append(column).append(" not in (");
                    int j = 1;
                    for (Object o : collection) {
                        String name = p + "_" + j;
                        addQueryParam(sql, name);
                        param.put(name, o);
                        if (j < collection.size())
                            sql.append(",");
                        j++;
                    }
                    sql.append(")");
                } else
                    throw new MagicException("notIn 入参不能为空！");
            } else if (key == Condition.sql) {
                sql.append(" ").append(column);
                if (value != null) {
                    param.putAll((Map<String, Object>) value);
                }
            }
        }

        if (orderBy != null) {
            boolean has = false;
            for (ConditionOrderBy by : orderBy) {
                if (by.getColumns() == null || by.getColumns().length == 0)
                    throw new MagicException("orderBy 排序列入参不能为空！");

                if (!has) {
                    sql.append(" order by ");
                } else
                    sql.append(", ");
                if (by.getBy() == Condition.orderByAsc) {// asc
                    if (!has)
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns())).append(" asc");
                    else
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns(), "asc"));
                } else if (by.getBy() == Condition.orderByDesc) {// desc
                    if (!has)
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns())).append(" desc");
                    else
                        sql.append(MagicEntityUtils.getOrderBy(by.getColumns(), "desc"));
                }
                has = true;
            }
        }

        return sql.toString();
    }

    protected void addQueryParam(StringBuilder sql, String p) {
        sql.append("#{" + BaseMapperSql.param_q + ".param.").append(p).append("}");
    }


    // get 、 set

    public String getSql() {
        if (list.isEmpty() && orderBy == null)
            return "";
        return sql + buildSql();
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public HashMap<String, Object> getParam() {
        return param;
    }

    public void setParam(HashMap<String, Object> param) {
        this.param = param;
    }
}
