package top.lingkang.mm.orm;

import top.lingkang.mm.error.MagicException;

import java.util.Collection;
import java.util.Map;

/**
 * @author lingkang
 * Created by 2024/3/20
 */
public class QueryColumn extends Query {
    private Class<?> resultClass;
    private String columns = "";

    /**
     * @param resultClass 返回的结果类
     * @param column      需要查询的列
     */
    public QueryColumn(Class<?> resultClass, String... column) {
        if (resultClass == null)
            throw new MagicException("结果类不能为空");
        if (column == null || column.length == 0)
            throw new MagicException("查询的列不能为空");
        this.resultClass = resultClass;
        int pre = column.length - 1;
        for (int i = 0; i < column.length; i++) {
            columns += column[i];
            if (i < pre)
                columns += ",";
        }
    }

    public String getColumns() {
        return columns;
    }

    public Class<?> getResultClass() {
        return resultClass;
    }

    // override -----------------------------------------------------------------------------------------


    @Override
    public QueryColumn eq(String column, Object value) {
        super.eq(column, value);
        return this;
    }

    @Override
    public QueryColumn ne(String column, Object value) {
        super.ne(column, value);
        return this;
    }

    @Override
    public QueryColumn gt(String column, Object value) {
        super.gt(column, value);
        return this;
    }

    @Override
    public QueryColumn ge(String column, Object value) {
        super.ge(column, value);
        return this;
    }

    @Override
    public QueryColumn lt(String column, Object value) {
        super.lt(column, value);
        return this;
    }

    @Override
    public QueryColumn le(String column, Object value) {
        super.le(column, value);
        return this;
    }

    @Override
    public QueryColumn like(String column, Object value) {
        super.like(column, value);
        return this;
    }

    @Override
    public QueryColumn notLike(String column, Object value) {
        super.notLike(column, value);
        return this;
    }

    @Override
    public QueryColumn likeLeft(String column, Object value) {
        super.likeLeft(column, value);
        return this;
    }

    @Override
    public QueryColumn likeRight(String column, Object value) {
        super.likeRight(column, value);
        return this;
    }

    @Override
    public QueryColumn notLikeLeft(String column, Object value) {
        super.notLikeLeft(column, value);
        return this;
    }

    @Override
    public QueryColumn notLikeRight(String column, Object value) {
        super.notLikeRight(column, value);
        return this;
    }

    @Override
    public QueryColumn isNull(String column, Object value) {
        super.isNull(column, value);
        return this;
    }

    @Override
    public QueryColumn isNotNull(String column, Object value) {
        super.isNotNull(column, value);
        return this;
    }

    @Override
    public QueryColumn in(String column, Collection value) {
        super.in(column, value);
        return this;
    }

    @Override
    public QueryColumn notIn(String column, Collection value) {
        super.notIn(column, value);
        return this;
    }

    @Override
    public QueryColumn orderByAsc(String... ascColumn) {
        super.orderByAsc(ascColumn);
        return this;
    }

    @Override
    public QueryColumn orderByDesc(String... descColumn) {
        super.orderByDesc(descColumn);
        return this;
    }

    @Override
    public QueryColumn or() {
        super.or();
        return this;
    }

    @Override
    public QueryColumn sql(String sql) {
        super.sql(sql);
        return this;
    }

    @Override
    public QueryColumn sql(String sql, Map<String, Object> param) {
        super.sql(sql, param);
        return this;
    }

    protected void addQueryParam(StringBuilder sql, String p) {
        sql.append("#{" + BaseMapperSql.param_q2 + ".param.").append(p).append("}");
    }
}
