/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.SqlSessionFactoryProxy;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.gen.DefaultIdGenerate;
import top.lingkang.mm.gen.IdGenerate;
import top.lingkang.mm.override.MagicReflectorFactory;
import top.lingkang.mm.page.MagicPageInterceptor;
import top.lingkang.mm.transaction.MagicTransactionFactory;
import top.lingkang.mm.utils.MagicUtils;

public class MagicConfiguration
extends Configuration {
    private static final Logger log = LoggerFactory.getLogger(MagicConfiguration.class);
    private List<String> scanMapperXml = new ArrayList<String>();
    private DataSource dataSource;
    public static IdGenerate idGenerate = new DefaultIdGenerate();
    private final List<String> amxCache = new ArrayList<String>();

    public MagicConfiguration() {
    }

    public MagicConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public MagicConfiguration setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new MagicException("dataSource \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.dataSource = dataSource;
        return this;
    }

    public MagicConfiguration addMapperXml(String ... mapperXml) {
        if (mapperXml == null) {
            throw new MagicException("addMapperXml \u4e0d\u80fd\u6dfb\u52a0\u7a7a\u503c");
        }
        for (String xml : mapperXml) {
            if (this.amxCache.contains(xml)) continue;
            if (xml.endsWith(".xml") && !xml.endsWith("*.xml")) {
                InputStream stream = ResourceUtil.getStream((String)xml);
                log.debug("\u52a0\u8f7d mapper xml: {}", (Object)xml);
                XMLMapperBuilder mapperParser = new XMLMapperBuilder(stream, (Configuration)this, xml, this.getSqlFragments());
                try {
                    mapperParser.parse();
                }
                catch (Exception e) {
                    if (e.getMessage().contains("already contains key")) {
                        log.error("\u5b58\u5728\u91cd\u590d\u7684\u63a5\u53e3\u65b9\u6cd5\uff0c\u5b83\u53ef\u80fd\u4e0e BaseMapper \u4e2d\u7684\u63a5\u53e3\u540d\u79f0\u51b2\u7a81");
                    }
                    throw e;
                }
                IoUtil.close((Closeable)stream);
            } else {
                XMLMapperBuilder mapperParser;
                InputStream inputStream;
                List<String> list;
                String targetXml = null;
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("");
                if (url == null) {
                    targetXml = xml.endsWith("*") ? xml + ".xml" : (xml.endsWith("/") ? xml + "*.xml" : xml + "/*.xml");
                    list = MagicUtils.scanResource(targetXml);
                    for (String string : list) {
                        if (!string.endsWith(".xml")) continue;
                        inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string);
                        log.debug("\u52a0\u8f7d mapper xml: {}", (Object)string);
                        mapperParser = new XMLMapperBuilder(inputStream, (Configuration)this, string, this.getSqlFragments());
                        try {
                            mapperParser.parse();
                        }
                        catch (Exception e) {
                            if (e.getMessage().contains("already contains key")) {
                                log.error("\u5b58\u5728\u91cd\u590d\u7684\u63a5\u53e3\u65b9\u6cd5\uff0c\u5b83\u53ef\u80fd\u4e0e BaseMapper \u51b2\u7a81");
                            }
                            throw e;
                        }
                        IoUtil.close((Closeable)inputStream);
                    }
                } else {
                    targetXml = xml.endsWith("**") ? xml.substring(0, xml.length() - 2) : (xml.endsWith("**.xml") ? xml.substring(0, xml.length() - 6) : (xml.endsWith("*.xml") ? xml.substring(0, xml.length() - 5) : xml));
                    list = FileUtil.loopFiles((String)targetXml);
                    for (File file : list) {
                        if (!file.getName().endsWith(".xml")) continue;
                        inputStream = FileUtil.getInputStream((File)file);
                        log.debug("\u52a0\u8f7d mapper xml: {}", (Object)file.getPath());
                        mapperParser = new XMLMapperBuilder(inputStream, (Configuration)this, file.getPath(), this.getSqlFragments());
                        try {
                            mapperParser.parse();
                        }
                        catch (Exception e) {
                            if (e.getMessage() != null && e.getMessage().contains("already contains key")) {
                                log.error("\u5b58\u5728\u91cd\u590d\u7684\u63a5\u53e3\u65b9\u6cd5\uff0c\u5b83\u53ef\u80fd\u4e0e BaseMapper \u51b2\u7a81");
                            }
                            throw e;
                        }
                        IoUtil.close((Closeable)inputStream);
                    }
                }
            }
            this.amxCache.add(xml);
        }
        this.scanMapperXml.addAll(Arrays.asList(mapperXml));
        return this;
    }

    public List<String> getScanMapperXml() {
        return this.scanMapperXml;
    }

    public IdGenerate getIdGenerate() {
        return idGenerate;
    }

    public MagicConfiguration setIdGenerate(IdGenerate idGenerate) {
        MagicConfiguration.idGenerate = idGenerate;
        return this;
    }

    public SqlSessionFactory build() {
        Environment environment = new Environment("magic", (TransactionFactory)new MagicTransactionFactory(), this.dataSource);
        this.setEnvironment(environment);
        this.setReflectorFactory(new MagicReflectorFactory());
        this.addInterceptor(new MagicPageInterceptor());
        SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build((Configuration)this);
        SqlSessionFactory sessionFactory = (SqlSessionFactory)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{SqlSessionFactory.class}, (InvocationHandler)new SqlSessionFactoryProxy(sqlSessionFactory));
        return sessionFactory;
    }
}

