/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.annotation.Id;
import top.lingkang.mm.constant.IdType;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.gen.DefaultIdGenerate;
import top.lingkang.mm.gen.IdGenerate;
import top.lingkang.mm.orm.MagicCreateLangMapper;
import top.lingkang.mm.orm.MagicEntity;
import top.lingkang.mm.orm.MagicEntityUtils;

class BaseMapperManage {
    private static final Logger log = LoggerFactory.getLogger(BaseMapperManage.class);
    public Configuration configuration;
    public SqlSession sqlSession;
    public IdGenerate idGenerate = new DefaultIdGenerate();
    private String template;
    public MagicCreateLangMapper langMapper;
    private Map<Class<?>, MagicEntity> cache = new HashMap();

    public BaseMapperManage(Configuration configuration, SqlSession sqlSession) {
        Assert.notNull((Object)sqlSession, (String)"sqlSession \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (sqlSession instanceof DefaultSqlSession) {
            throw new MagicException("\u521b\u5efa BaseMapperManage \u7684 sqlSession \u4e0d\u80fd\u662f: " + sqlSession.getClass().getName());
        }
        this.configuration = configuration;
        this.sqlSession = sqlSession;
        this.template = IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("MagicTemplate.xml"), (Charset)StandardCharsets.UTF_8);
        configuration.addMapper(MagicCreateLangMapper.class);
        this.langMapper = (MagicCreateLangMapper)configuration.getMapper(MagicCreateLangMapper.class, sqlSession);
    }

    public boolean isLoad(Class<?> clazz) {
        return this.cache.containsKey(clazz);
    }

    public MagicEntity getMagicEntity(Class<?> clazz) {
        MagicEntity entity = this.cache.get(clazz);
        if (entity != null) {
            return entity;
        }
        entity = MagicEntityUtils.getMagicEntity(this.configuration, clazz);
        this.cache.put(clazz, entity);
        this.loadTemplate(entity);
        return entity;
    }

    protected void loadTemplate(MagicEntity entity) {
        int idIndex = entity.getIdIndex();
        String temp = this.template.replace("index_", entity.getClazz().getName()).replace("table_", entity.getTableName()).replace("columns_", MagicEntityUtils.getColumns(entity.getColumnName(), null)).replace("entityType_", entity.getClazz().getName()).replace("id_", idIndex == -1 ? "_" : (CharSequence)entity.getColumnName().get(idIndex)).replace("values_", this.getInsertValues(entity)).replace("sequence_values", this.getInsertValuesSequence(entity)).replace("columnsE_", MagicEntityUtils.getInsertPrefixValues(entity, "e")).replace("setColumns_", MagicEntityUtils.getSetColumns(entity, null));
        ByteArrayInputStream in = IoUtil.toStream((String)temp, (Charset)StandardCharsets.UTF_8);
        XMLMapperBuilder mapperParser = new XMLMapperBuilder((InputStream)in, this.configuration, entity.getClazz().getName(), this.configuration.getSqlFragments());
        mapperParser.parse();
        log.debug("{} --> {}", (Object)entity.getClazz().getName(), (Object)temp);
    }

    private String getInsertValues(MagicEntity entity) {
        List<String> col = entity.getColumnName();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < col.size(); ++i) {
            res.append("#{").append(col.get(i)).append("}");
            if (i >= col.size() - 1) continue;
            res.append(",");
        }
        return res.toString();
    }

    private String getInsertValuesSequence(MagicEntity entity) {
        boolean isSequence = false;
        if (entity.getIdAnn() != null && entity.getIdAnn().value() == IdType.AUTO && StrUtil.isNotEmpty((CharSequence)entity.getIdAnn().sequence())) {
            isSequence = true;
        }
        List<String> col = entity.getColumnName();
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < col.size(); ++i) {
            if (isSequence && i == entity.getIdIndex()) {
                res.append("nextval('").append(entity.getIdAnn().sequence()).append("')");
            } else {
                res.append("#{").append(col.get(i)).append("}");
            }
            if (i >= col.size() - 1) continue;
            res.append(",");
        }
        return res.toString();
    }

    public Map<String, Object> getUpdateNotNullParams(Object obj, MagicEntity entity) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuilder columns = new StringBuilder();
        for (int i = 0; i < entity.getColumnName().size(); ++i) {
            try {
                Field field = entity.getFields().get(i);
                field.setAccessible(true);
                if (field.get(obj) != null) {
                    columns.append(entity.getColumnName().get(i)).append("=#{e.").append(entity.getFields().get(i).getName()).append("}, ");
                    continue;
                }
                if (i != entity.getIdIndex()) continue;
                throw new MagicException("\u66f4\u65b0\u5bf9\u8c61\u7684 " + field.getName() + " \u4e0d\u80fd\u4e3a\u7a7a\u503c: " + obj);
            }
            catch (Exception e) {
                throw new MagicException(e);
            }
        }
        if (columns.length() == 0) {
            throw new MagicException("\u4e0d\u80fd\u66f4\u65b0\u5168\u7a7a\u503c\uff1a" + obj);
        }
        param.put("columns", columns.substring(0, columns.length() - 2));
        param.put("e", obj);
        return param;
    }

    public String getSqlId(Class<?> clazz, String action) {
        MagicEntity entity = this.getMagicEntity(clazz);
        return this.getSqlId(entity, action);
    }

    public String getSqlId(MagicEntity entity, String action) {
        return "magic_" + entity.getClazz().getName() + "." + action;
    }

    public String getQtId(String id) {
        return "magicQuery." + id;
    }

    public void checkIdSet(MagicEntity entity, Object obj, IdGenerate idGenerate) {
        Id id = entity.getIdAnn();
        if (id != null && id.value() == IdType.ASSIGN) {
            String idName = entity.getFields().get(entity.getIdIndex()).getName();
            try {
                Field field = entity.getClazz().getDeclaredField(idName);
                field.setAccessible(true);
                Object oId = field.get(obj);
                if (oId != null) {
                    return;
                }
                Object genId = idGenerate.nextId(id.assignParam());
                if (field.getType() != genId.getClass()) {
                    throw new MagicException("IdGenerate \u81ea\u52a8\u751f\u6210 id \u7c7b\u578b: " + genId.getClass().getName() + "  \u4e0e\u5b9e\u4f53\u7c7b id \u7c7b\u578b\u4e0d\u4e00\u81f4: " + field.getType().getName() + "  \u5b9e\u4f53\u7c7b: " + entity.getClazz().getName());
                }
                field.setAccessible(true);
                field.set(obj, genId);
            }
            catch (Exception e) {
                throw new MagicException(e);
            }
        }
    }

    protected Object getIdValue(Object obj, Class<?> clazz, String name) {
        try {
            String metName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            Method method = clazz.getDeclaredMethod(metName, new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception metName) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public IdGenerate getIdGenerate() {
        return this.idGenerate;
    }

    public void setIdGenerate(IdGenerate idGenerate) {
        this.idGenerate = idGenerate;
    }
}

