/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.transaction.TransactionManage;

public class MagicTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(MagicTransaction.class);
    private final DataSource dataSource;
    private Connection connection;

    public MagicTransaction(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        this.connection = TransactionManage.getConnection(this.dataSource);
        return this.connection;
    }

    public void commit() throws SQLException {
        if (TransactionManage.isTransaction()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (TransactionManage.isTransaction()) {
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Integer getTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }
}

