/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.AntPathMatcher;
import cn.hutool.core.util.ClassUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.error.MagicException;

public class MagicUtils {
    private static final Logger log = LoggerFactory.getLogger(MagicUtils.class);
    private static final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private static final Map<String, List<String>> scanCache = new HashMap<String, List<String>>();

    public static List<String> scanResource(String scanPath) {
        List<String> list = scanCache.get(scanPath);
        if (list != null) {
            return list;
        }
        URL url = MagicUtils.class.getClassLoader().getResource("top");
        ArrayList<String> result = new ArrayList<String>();
        try {
            if (url != null) {
                JarFile jarFile = null;
                URLConnection con = url.openConnection();
                if (con instanceof JarURLConnection) {
                    JarURLConnection jarCon = (JarURLConnection)con;
                    jarFile = jarCon.getJarFile();
                } else {
                    String urlFile = url.getFile();
                    int separatorIndex = urlFile.indexOf("*/");
                    if (separatorIndex == -1) {
                        separatorIndex = urlFile.indexOf("!/");
                    }
                    if (separatorIndex != -1) {
                        String rootEntryPath = urlFile.substring(separatorIndex + 2);
                        jarFile = new JarFile(rootEntryPath);
                    }
                }
                if (jarFile != null) {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!antPathMatcher.match(scanPath, entryName)) continue;
                        result.add(entryName);
                    }
                    jarFile.close();
                } else {
                    File file;
                    URL resource = MagicUtils.class.getClassLoader().getResource("");
                    if (resource != null && (file = new File(resource.getPath() + scanPath)).listFiles() != null) {
                        for (File f : file.listFiles()) {
                            result.add(f.getPath());
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MagicException(e);
        }
        scanCache.put(scanPath, result);
        return result;
    }

    public static Method[] getAllPublicMethod(Class<?> clazz) {
        return ClassUtil.getPublicMethods(clazz);
    }

    public static Field[] getAllField(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            for (Field field : superclass.getDeclaredFields()) {
                if (MagicUtils.existsFieldName(field, list)) continue;
                list.add(field);
            }
        }
        return list.toArray(new Field[0]);
    }

    private static boolean existsFieldName(Field field, List<Field> list) {
        for (Field f : list) {
            if (!f.getName().equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    public static void exeScript(File sqlScriptFile, Connection connection) {
        MagicUtils.exeScript(FileUtil.readString((File)sqlScriptFile, (Charset)StandardCharsets.UTF_8), connection);
    }

    public static void exeScript(String sqlScript, Connection connection) {
        long start = System.currentTimeMillis();
        String tempSql = "";
        int number = 1;
        try {
            sqlScript = sqlScript.replaceAll("-- .*", "");
            sqlScript = sqlScript.replaceAll("--.*", "");
            Pattern pattern = Pattern.compile("/\\*([^*]|[\\r\\n]|(\\*+([^*/]|[\\r\\n])))*\\*+/", 40);
            Matcher matcher = pattern.matcher(sqlScript);
            sqlScript = matcher.replaceAll("");
            sqlScript = sqlScript.replace("\n", "");
            sqlScript = sqlScript.replace(System.getProperty("line.separator", "\n"), "");
            String[] split = sqlScript.split(";");
            log.info("\u5f00\u59cb\u6267\u884csql\u811a\u672c");
            connection.setAutoCommit(false);
            for (String sql : split) {
                if (sql.length() < 10) continue;
                tempSql = sql;
                PreparedStatement ps = connection.prepareStatement(sql);
                ps.executeUpdate();
                ps.close();
                ++number;
            }
            connection.commit();
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u811a\u672c\u51fa\u9519\uff0c\u4e8b\u52a1\u56de\u6eda\u3002\u6267\u884c\u9519\u8bef\u7684sql\u662f\uff1a\n{}", (Object)tempSql);
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                throw new MagicException(ex);
            }
            throw new MagicException(e);
        }
        finally {
            IoUtil.close((AutoCloseable)connection);
            log.info("sql \u6267\u884c\u5b8c\u6bd5\uff0c\u5171\u6267\u884csql {} \u4e2a\uff0c\u8017\u65f6\uff1a{} ms", (Object)number, (Object)(System.currentTimeMillis() - start));
        }
    }
}

