package top.lingkang.mm.orm;

import java.util.HashMap;
import java.util.Map;

/**
 * 更新包装对象，例1 ：
 * <pre>
 * {@code
 *     UpadateWrapper update = mapperManage.createUpdate("update t_user set password=#{p} where id=#{id}");
 *     update.addParam("p", System.currentTimeMillis()).addParam("id", 1);
 *     int execute = update.execute();
 *     log.info("受影响行数: {}", execute);
 * }
 * </pre>
 * 例2：
 * <pre>
 * {@code
 *     UpadateWrapper update = mapperManage.createUpdate("insert into t_user(id,username) values (2,#{un})");
 *     update.addParam("un", "lk");
 *     int execute = update.execute();
 *     log.info("受影响行数: {}", execute);
 * }
 * </pre>
 *
 * @author lingkang
 * @create by 2024/3/6
 */
public class UpadateWrapper {
    private String sql;
    private MapperManageImpl manage;

    public UpadateWrapper(String sql, MapperManageImpl manage) {
        this.sql = sql;
        this.manage = manage;
    }

    private Map<String, Object> params = new HashMap<>();

    /**
     * 添加参数，sql中的参数只能用 #{paramName} <br>
     * 代码例子：
     * <pre>
     * {@code
     *     UpadateWrapper update = mapperManage.createUpdate("update t_user set password=#{p} where id=#{id}");
     *     update.addParam("p", System.currentTimeMillis()).addParam("id", 1);
     *     int execute = update.execute();
     *     log.info("受影响行数: {}", execute);
     * }
     * </pre>
     *
     * @param name  参数名
     * @param value 参数值
     * @return 查询包装对象
     */
    public UpadateWrapper addParam(String name, Object value) {
        params.put(name, value);
        return this;
    }

    /**
     * 添加 map 参数
     *
     * @param params map参数
     * @return 查询包装对象
     */
    public UpadateWrapper addParam(Map<String, Object> params) {
        params.putAll(params);
        return this;
    }

    /**
     * 获取参数
     *
     * @return map 参数
     */
    public Map<String, Object> getParams() {
        return params;
    }

    /**
     * 执行更新操作
     *
     * @return 受影响行数
     */
    public int execute() {
        params.put("execSql_", sql);
        return manage.langMapper.update(params);
    }


}
