/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import cn.hutool.core.lang.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.orm.Condition;
import top.lingkang.mm.orm.ConditionHandler;
import top.lingkang.mm.orm.ConditionOrderBy;
import top.lingkang.mm.orm.ConditionValue;
import top.lingkang.mm.orm.MagicEntityUtils;
import top.lingkang.mm.orm.QueryUtils;

class BaseQuery {
    protected List<ConditionValue> list = new ArrayList<ConditionValue>();
    protected List<ConditionOrderBy> orderBy;
    protected String sql = "";
    protected HashMap<String, Object> param = new HashMap();
    protected static final Map<Condition, ConditionHandler> handlers = new HashMap<Condition, ConditionHandler>();

    BaseQuery() {
    }

    public BaseQuery symbol(String column, String symbol, Object value) {
        this.list.add(new ConditionValue(Condition.symbol, column, value).setSymbol(symbol));
        return this;
    }

    public BaseQuery eq(String column, Object value) {
        this.list.add(new ConditionValue(Condition.eq, column, value));
        return this;
    }

    public BaseQuery ne(String column, Object value) {
        this.list.add(new ConditionValue(Condition.ne, column, value));
        return this;
    }

    public BaseQuery gt(String column, Object value) {
        this.list.add(new ConditionValue(Condition.gt, column, value));
        return this;
    }

    public BaseQuery ge(String column, Object value) {
        this.list.add(new ConditionValue(Condition.ge, column, value));
        return this;
    }

    public BaseQuery lt(String column, Object value) {
        this.list.add(new ConditionValue(Condition.lt, column, value));
        return this;
    }

    public BaseQuery le(String column, Object value) {
        this.list.add(new ConditionValue(Condition.le, column, value));
        return this;
    }

    public BaseQuery like(String column, Object value) {
        this.list.add(new ConditionValue(Condition.like, column, value));
        return this;
    }

    public BaseQuery notLike(String column, Object value) {
        this.list.add(new ConditionValue(Condition.notLike, column, value));
        return this;
    }

    public BaseQuery likeLeft(String column, Object value) {
        this.list.add(new ConditionValue(Condition.likeLeft, column, value));
        return this;
    }

    public BaseQuery likeRight(String column, Object value) {
        this.list.add(new ConditionValue(Condition.likeRight, column, value));
        return this;
    }

    public BaseQuery notLikeLeft(String column, Object value) {
        this.list.add(new ConditionValue(Condition.notLikeLeft, column, value));
        return this;
    }

    public BaseQuery notLikeRight(String column, Object value) {
        this.list.add(new ConditionValue(Condition.notLikeRight, column, value));
        return this;
    }

    public BaseQuery isNull(String column) {
        this.list.add(new ConditionValue(Condition.isNull, column, null));
        return this;
    }

    public BaseQuery isNotNull(String column) {
        this.list.add(new ConditionValue(Condition.isNotNull, column, null));
        return this;
    }

    public BaseQuery in(String column, Collection value) {
        this.list.add(new ConditionValue(Condition.in, column, value));
        return this;
    }

    public BaseQuery notIn(String column, Collection value) {
        this.list.add(new ConditionValue(Condition.notIn, column, value));
        return this;
    }

    public BaseQuery orderByAsc(String ... ascColumn) {
        Assert.notNull((Object)ascColumn, (String)"\u6392\u5e8f\u7684\u5217\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<ConditionOrderBy>();
        }
        this.orderBy.add(new ConditionOrderBy(Condition.orderByAsc, ascColumn));
        return this;
    }

    public BaseQuery orderByDesc(String ... descColumn) {
        Assert.notNull((Object)descColumn, (String)"\u6392\u5e8f\u7684\u5217\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<ConditionOrderBy>();
        }
        this.orderBy.add(new ConditionOrderBy(Condition.orderByDesc, descColumn));
        return this;
    }

    public BaseQuery or() {
        this.list.add(new ConditionValue(Condition.or));
        return this;
    }

    public BaseQuery sql(String sql) {
        this.list.add(new ConditionValue(Condition.sql, sql, null));
        return this;
    }

    public BaseQuery sql(String sql, Map<String, Object> param) {
        this.list.add(new ConditionValue(Condition.sql, sql, param));
        return this;
    }

    public String buildSql() {
        StringBuilder str_ = new StringBuilder();
        boolean isOr = false;
        int i = 1;
        for (ConditionValue conditionValue : this.list) {
            Condition key = conditionValue.getCondition();
            if (key == Condition.or) {
                str_.append(" or ");
                isOr = true;
                continue;
            }
            if (key == Condition.sql) {
                str_.append(" ").append(conditionValue.getColumn());
                Object value = conditionValue.getValue();
                if (value != null) {
                    this.param.putAll((Map)value);
                }
                return str_.toString();
            }
            if (!isOr) {
                str_.append(" and ");
            } else {
                isOr = false;
            }
            String p = "p" + i++;
            handlers.get((Object)conditionValue.getCondition()).handle(str_, this, conditionValue, p);
        }
        if (this.orderBy != null) {
            boolean has = false;
            for (ConditionOrderBy by : this.orderBy) {
                if (by.getColumns() == null || by.getColumns().length == 0) {
                    throw new MagicException("orderBy \u6392\u5e8f\u5217\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!has) {
                    str_.append(" order by ");
                } else {
                    str_.append(", ");
                }
                if (by.getBy() == Condition.orderByAsc) {
                    if (!has) {
                        str_.append(MagicEntityUtils.getOrderBy(by.getColumns())).append(" asc");
                    } else {
                        str_.append(MagicEntityUtils.getOrderBy(by.getColumns(), "asc"));
                    }
                } else if (by.getBy() == Condition.orderByDesc) {
                    if (!has) {
                        str_.append(MagicEntityUtils.getOrderBy(by.getColumns())).append(" desc");
                    } else {
                        str_.append(MagicEntityUtils.getOrderBy(by.getColumns(), "desc"));
                    }
                }
                has = true;
            }
        }
        return str_.toString();
    }

    protected void addQueryParam(StringBuilder sql, String p) {
        sql.append("#{").append("q").append(".param.").append(p).append("}");
    }

    public String getSql() {
        if (this.list.isEmpty() && this.orderBy == null) {
            return "";
        }
        return "where 1=1" + this.buildSql();
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public HashMap<String, Object> getParam() {
        return this.param;
    }

    public void setParam(HashMap<String, Object> param) {
        this.param = param;
    }

    static {
        QueryUtils.initHandler(handlers);
    }
}

