/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.page;

import cn.hutool.core.lang.Assert;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.page.PageInfo;
import top.lingkang.mm.page.PageSqlHandle;
import top.lingkang.mm.page.PageSqlHandleH2;
import top.lingkang.mm.page.PageSqlHandleMySql;
import top.lingkang.mm.page.PageSqlHandlePostgreSql;
import top.lingkang.mm.page.PageSqlHandleSqlServer;
import top.lingkang.mm.page.PageSqlHandleSqlite;
import top.lingkang.mm.utils.MagicUtils;

public class PageHelper {
    private static final Logger log = LoggerFactory.getLogger(PageHelper.class);
    private static final ThreadLocal<PageInfo> local = new ThreadLocal();
    public static PageSqlHandle pageSqlHandle;

    public static void startPage(int page, int size) {
        Assert.isTrue((page > 0 ? 1 : 0) != 0, (String)"page \u6700\u5c0f\u503c\u4e3a 1", (Object[])new Object[0]);
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"size \u5fc5\u987b\u5927\u4e8e 0", (Object[])new Object[0]);
        PageInfo info = new PageInfo();
        info.setSize(size);
        info.setPage(page);
        info.setComplete(false);
        local.set(info);
    }

    public static PageInfo getPage() {
        PageInfo info = local.get();
        if (info == null) {
            return null;
        }
        if (info.isComplete()) {
            local.remove();
        }
        return info;
    }

    public static void initPageHandler(Connection connection) {
        PageHelper.getHandle(connection);
    }

    public static PageSqlHandle getHandle(Connection connection) {
        if (pageSqlHandle != null) {
            return pageSqlHandle;
        }
        try {
            String url = MagicUtils.getDatabaseURL(connection, false);
            pageSqlHandle = PageHelper.getByType(url);
            if (pageSqlHandle == null) {
                throw new MagicException("\u672a\u8bc6\u522b\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + url);
            }
        }
        catch (Exception e) {
            log.warn("\u5206\u9875\u8bc6\u522b\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff0c\u5c06\u9ed8\u8ba4\u4f7f\u7528mysql\u5904\u7406\uff0c\u60a8\u53ef\u4ee5\u66f4\u6539 PageHelper.pageSqlHandle \u5206\u9875\u5904\u7406", (Throwable)e);
            pageSqlHandle = new PageSqlHandleMySql();
        }
        return pageSqlHandle;
    }

    private static PageSqlHandle getByType(String name) {
        if ((name = name.toLowerCase()).contains(":mysql:")) {
            return new PageSqlHandleMySql();
        }
        if (name.contains(":postgresql:")) {
            return new PageSqlHandlePostgreSql();
        }
        if (name.contains(":h2:")) {
            return new PageSqlHandleH2();
        }
        if (name.contains(":sqlite:")) {
            return new PageSqlHandleSqlite();
        }
        if (name.contains(":sqlserver:")) {
            return new PageSqlHandleSqlServer();
        }
        return null;
    }
}

