/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import top.lingkang.mm.annotation.Table;
import top.lingkang.mm.constant.IdType;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.orm.BaseInterface;
import top.lingkang.mm.orm.BaseMapperSql;
import top.lingkang.mm.orm.MagicEntity;
import top.lingkang.mm.orm.MagicEntityUtils;
import top.lingkang.mm.orm.QueryColumn;
import top.lingkang.mm.orm.UpdateColumn;
import top.lingkang.mm.utils.MagicUtils;

public class BaseMapperDriver
extends XMLLanguageDriver
implements LanguageDriver {
    private final Field loadedResources;
    private final Field keyProperties;
    private final Field keyColumns;
    private final Field resultClass;
    private final List<String> mapperMethod = new ArrayList<String>();
    private static final String curr = "current_" + new Date().getTime();
    private static final String currentTime = "q2.param." + curr;

    public BaseMapperDriver() {
        try {
            this.loadedResources = Configuration.class.getDeclaredField("loadedResources");
            this.loadedResources.setAccessible(true);
            this.keyProperties = MappedStatement.class.getDeclaredField("keyProperties");
            this.keyProperties.setAccessible(true);
            this.keyColumns = MappedStatement.class.getDeclaredField("keyColumns");
            this.keyColumns.setAccessible(true);
            this.resultClass = ResultMap.class.getDeclaredField("type");
            this.resultClass.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public SqlSource createSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        return super.createSqlSource(configuration, script, parameterType);
    }

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        if (!BaseMapperSql.isBaseMapperSql(script)) {
            return super.createSqlSource(configuration, script, parameterType);
        }
        List<BaseInterface> interfaces = this.loadedBaseMapperInterface(configuration);
        BaseInterface interface_ = null;
        for (BaseInterface baseInterface : interfaces) {
            if (this.mapperMethod.contains(baseInterface.getInterfaceStr() + "-" + script)) continue;
            interface_ = baseInterface;
            break;
        }
        this.mapperMethod.add(interface_.getInterfaceStr() + "-" + script);
        MagicEntity entity = MagicEntityUtils.getMagicEntity(interface_.getEntityClass());
        switch (script) {
            case "magic_base_selectAll": {
                script = entity.getSelectTableSql();
                break;
            }
            case "magic_base_createQuery": {
                script = entity.getSelectTableSql() + " ${q.sql}";
                break;
            }
            case "magic_base_selectById": {
                if (entity.getIdIndex() == -1) {
                    script = "-1: " + interface_.getInter().getName() + ".selectById \u67e5\u8be2\u7684\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u67e5\u8be2\u5931\u8d25";
                    break;
                }
                script = entity.getSelectTableSql() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "id" + "}";
                break;
            }
            case "magic_base_selectInIds": {
                if (entity.getIdIndex() == -1) {
                    script = "-1: " + interface_.getInter().getName() + ".selectInIds \u67e5\u8be2\u7684\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u67e5\u8be2\u5931\u8d25";
                    break;
                }
                script = "<script>" + entity.getSelectTableSql() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + " in (<foreach collection=\"" + "id3" + "\" item=\"e\" separator=\",\">#{e}</foreach>)</script>";
                break;
            }
            case "magic_base_selectByQuery": {
                script = entity.getSelectTableSql() + " ${q.sql}";
                break;
            }
            case "magic_base_selectByQueryOne": {
                script = entity.getSelectTableSql() + " ${q.sql}";
                break;
            }
            case "magic_base_existsById": {
                if (entity.getIdIndex() == -1) {
                    script = "-1: " + interface_.getInter().getName() + ".existsById \u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u67e5\u8be2\u5931\u8d25";
                    break;
                }
                script = "select count(*) from " + entity.getTableName() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "id" + "}";
                break;
            }
            case "magic_base_existsByEntity": {
                if (entity.getIdIndex() == -1) {
                    script = "-1: " + interface_.getInter().getName() + ".existsByEntity \u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u67e5\u8be2\u5931\u8d25";
                    break;
                }
                script = "select count(*) from " + entity.getTableName() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "id2" + "}";
                break;
            }
            case "magic_base_existsByQuery": {
                script = "select count(*) from " + entity.getTableName() + " ${q.sql}";
                break;
            }
            case "magic_base_selectCount": {
                script = "select count(*) from " + entity.getTableName();
                break;
            }
            case "magic_base_selectCountByQuery": {
                script = "select count(*) from " + entity.getTableName() + " ${q.sql}";
                break;
            }
            case "magic_base_selectColumn": {
                script = "select ${q2.columns} from " + entity.getTableName() + " ${q2.sql}";
                break;
            }
            case "magic_base_selectColumnOne": {
                script = "select ${q2.columns} from " + entity.getTableName() + " ${q2.sql}";
                break;
            }
            case "magic_base_insert": {
                script = "insert into " + entity.getTableName() + "(" + MagicEntityUtils.getColumns(entity.getColumnName(), null) + ") values(" + MagicEntityUtils.getInsertValues(entity, "e") + ")";
                break;
            }
            case "magic_base_insertBatch": {
                script = "<script>insert into " + entity.getTableName() + "(" + MagicEntityUtils.getColumns(entity.getColumnName(), null) + ") values <foreach collection=\"" + "list" + "\" index=\"\" item=\"e\" separator=\",\">(" + MagicEntityUtils.getInsertPrefixValues(entity, "e") + ")</foreach></script>";
                break;
            }
            case "magic_base_updateById": {
                if (entity.getIdIndex() != -1) {
                    script = "update " + entity.getTableName() + " set " + MagicEntityUtils.getSetColumns(entity, "e") + " where " + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "e" + "." + entity.getFields().get(entity.getIdIndex()).getName() + "}";
                    break;
                }
                script = "-1";
                break;
            }
            case "magic_base_updateByQuery": {
                script = "update " + entity.getTableName() + " set " + MagicEntityUtils.getSetColumns(entity, "e") + " ${q.sql}";
                break;
            }
            case "magic_base_updateByColumn": {
                if (entity.getAutoUpdateTimeColumn() == null) {
                    script = "update " + entity.getTableName() + " set ${q2.sql}";
                    break;
                }
                List<String> autoUpdateTimeColumn = entity.getAutoUpdateTimeColumn();
                StringBuilder updateTimeSql = new StringBuilder("update ").append(entity.getTableName()).append(" set ");
                for (String column : autoUpdateTimeColumn) {
                    updateTimeSql.append(column).append("=#{").append(currentTime).append("},");
                }
                String sql = updateTimeSql.append("${q2.sql}").toString();
                return new DynamicSqlSource(configuration, (SqlNode)new TextSqlNode(sql));
            }
            case "magic_base_deleteById": {
                if (entity.getIdIndex() == -1) {
                    script = "-1: " + interface_.getInter().getName() + ".deleteById \u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u5220\u9664\u5931\u8d25";
                    break;
                }
                script = "delete from " + entity.getTableName() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + "=#{" + "id" + "}";
                break;
            }
            case "magic_base_deleteInIds": {
                if (entity.getIdIndex() == -1) {
                    script = "-1: " + interface_.getInter().getName() + ".deleteInIds \u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName() + " \u5220\u9664\u5931\u8d25";
                    break;
                }
                script = "<script>delete from " + entity.getTableName() + " where ";
                script = script + entity.getColumnName().get(entity.getIdIndex()) + " in (<foreach collection=\"" + "id2" + "\" item=\"e\" separator=\",\">#{e}</foreach>)</script>";
                break;
            }
            case "magic_base_deleteByQuery": {
                script = "delete from " + entity.getTableName() + " ${q.sql}";
            }
        }
        return super.createSqlSource(configuration, script, parameterType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterHandler createParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        Object object;
        if (mappedStatement.getSqlCommandType() == SqlCommandType.SELECT) {
            if (boundSql.getSql().startsWith("-1")) {
                throw new MagicException(boundSql.getSql());
            }
            if (!(parameterObject instanceof MapperMethod.ParamMap)) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
            MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
            if (map.containsKey((Object)"q2")) {
                Object object2 = map.get((Object)"q2");
                try {
                    this.resultClass.set(mappedStatement.getResultMaps().get(0), ((QueryColumn)object2).getResultClass());
                    return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
                }
                catch (IllegalAccessException e) {
                    throw new MagicException(e);
                }
            } else {
                if (!map.containsKey((Object)"id2")) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
                Object object3 = map.get((Object)"id2");
                MagicEntity entity = MagicEntityUtils.getMagicEntity(object3.getClass());
                Field field = entity.getFields().get(entity.getIdIndex());
                Object value = MagicUtils.getValue(field, object3);
                if (value == null) {
                    throw new MagicException("\u5b9e\u4f53\u5165\u53c2\u7684 id \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff1a" + object3);
                }
                map.put((Object)"id2", value);
            }
            return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
        }
        if (mappedStatement.getSqlCommandType() == SqlCommandType.UPDATE) {
            if (parameterObject == null) {
                throw new MagicException("\u66f4\u65b0\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a! ");
            }
            MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
            if (map.containsKey((Object)"e")) {
                Object object4 = map.get((Object)"e");
                MagicEntity entity = MagicEntityUtils.getMagicEntity(object4.getClass());
                if (!map.containsKey((Object)"q") && entity.getIdIndex() == -1) {
                    throw new MagicException("\u66f4\u65b0\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName());
                }
                MagicEntityUtils.autoSetTime(entity, object4, false);
                MagicEntityUtils.execPreUpdate(entity, object4);
                return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
            } else {
                if (!map.containsKey((Object)"q2") || !currentTime.equals(((ParameterMapping)boundSql.getParameterMappings().get(0)).getProperty())) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
                UpdateColumn updateColumn = (UpdateColumn)map.get((Object)"q2");
                updateColumn.param.put(curr, new Date());
            }
            return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
        }
        if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT) {
            try {
                if (parameterObject == null || parameterObject.getClass() != MapperMethod.ParamMap.class) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
                MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
                if (map.containsKey((Object)"e")) {
                    Object object5 = map.get((Object)"e");
                    MagicEntity entity = MagicEntityUtils.getMagicEntity(object5.getClass());
                    if (entity.getIdIndex() != -1) {
                        if (entity.getIdAnn().value() == IdType.AUTO) {
                            this.keyProperties.set(mappedStatement, new String[]{entity.getFields().get(entity.getIdIndex()).getName()});
                            this.keyColumns.set(mappedStatement, new String[]{entity.getColumnName().get(entity.getIdIndex())});
                        } else if (entity.getIdAnn().value() == IdType.ASSIGN) {
                            MagicEntityUtils.setIdValue(object5, mappedStatement.getConfiguration(), entity);
                        }
                    }
                    MagicEntityUtils.autoSetTime(entity, object5, true);
                    MagicEntityUtils.execPreUpdate(entity, object5);
                    return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
                }
                Object object6 = map.get((Object)"list");
                if (object6 == null) {
                    throw new MagicException("\u63d2\u5165\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                List list = (List)object6;
                if (list.isEmpty()) {
                    throw new MagicException("\u63d2\u5165\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                MagicEntity entity = MagicEntityUtils.getMagicEntity(list.get(0).getClass());
                if (entity.getIdIndex() != -1) {
                    if (entity.getIdAnn().value() == IdType.AUTO) {
                        this.keyProperties.set(mappedStatement, new String[]{entity.getFields().get(entity.getIdIndex()).getName()});
                        this.keyColumns.set(mappedStatement, new String[]{entity.getColumnName().get(entity.getIdIndex())});
                    } else if (entity.getIdAnn().value() == IdType.ASSIGN) {
                        for (Object o : list) {
                            MagicEntityUtils.setIdValue(o, mappedStatement.getConfiguration(), entity);
                        }
                    }
                }
                MagicEntityUtils.autoSetTimeList(entity, list, true);
                MagicEntityUtils.execPreUpdateList(entity, list);
                return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
            }
            catch (Exception e) {
                throw new MagicException(e);
            }
        }
        if (mappedStatement.getSqlCommandType() != SqlCommandType.DELETE) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
        if (parameterObject == null) {
            throw new MagicException("\u5220\u9664\u7684id\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a! ");
        }
        if (boundSql.getSql().startsWith("-1")) {
            throw new MagicException(boundSql.getSql());
        }
        MapperMethod.ParamMap map = (MapperMethod.ParamMap)parameterObject;
        if (!map.containsKey((Object)"id") || (object = map.get((Object)"id")).getClass().getAnnotation(Table.class) == null) return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
        MagicEntity entity = MagicEntityUtils.getMagicEntity(object.getClass());
        if (entity.getIdIndex() == -1) {
            throw new MagicException("\u5220\u9664\u7684\u5b9e\u4f53\u7c7b\u6ca1\u6709 @Id \u6ce8\u89e3: " + entity.getClazz().getName());
        }
        Object id = null;
        try {
            id = entity.getFields().get(entity.getIdIndex()).get(object);
        }
        catch (IllegalAccessException e) {
            throw new MagicException(e);
        }
        map.put((Object)"id", id);
        return super.createParameterHandler(mappedStatement, parameterObject, boundSql);
    }

    private List<BaseInterface> loadedBaseMapperInterface(Configuration configuration) {
        ArrayList<BaseInterface> result = new ArrayList<BaseInterface>();
        try {
            HashSet set = (HashSet)this.loadedResources.get(configuration);
            for (String inter : set) {
                String interfaceName;
                Class<?> interface_;
                Type[] genericInterfaces;
                if (!inter.startsWith("interface") || (genericInterfaces = (interface_ = ((Object)((Object)this)).getClass().getClassLoader().loadClass(inter.split(" ")[1])).getGenericInterfaces()).length == 0 || (interfaceName = this.getBaseMapperInterfaceName(genericInterfaces)) == null) continue;
                BaseInterface baseInterface = new BaseInterface();
                baseInterface.setInterfaceStr(inter);
                baseInterface.setInter(interface_);
                String entityClassName = this.getEntityClassName(interfaceName, interface_.getName());
                Class<?> entityClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(entityClassName);
                baseInterface.setEntityClass(entityClass);
                result.add(baseInterface);
            }
        }
        catch (Exception e) {
            throw new MagicException(e);
        }
        return result;
    }

    private String getEntityClassName(String name, String interfaceName) {
        if (!name.endsWith(">")) {
            throw new IllegalStateException("BaseMapper\u5fc5\u987b\u8bbe\u7f6e\u597d\u6620\u5c04\u6cdb\u578b\u5b9e\u4f53\u7c7b\uff0c\u4f8b\u5982\uff1aUserMapper extends BaseMapper<UserEntity>\uff0c\u5f53\u524d\u63a5\u53e3\uff1a" + interfaceName);
        }
        String substring = name.substring(31);
        return substring.substring(0, substring.length() - 1);
    }

    private String getBaseMapperInterfaceName(Type[] genericInterfaces) {
        for (Type name : genericInterfaces) {
            if (!name.getTypeName().startsWith("top.lingkang.mm.orm.BaseMapper")) continue;
            return name.getTypeName();
        }
        return null;
    }
}

