/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.mm.SqlSessionFactoryProxy;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.gen.DefaultIdGenerate;
import top.lingkang.mm.gen.IdGenerate;
import top.lingkang.mm.handler.MagicSqliteDateTypeHandler;
import top.lingkang.mm.override.MagicReflectorFactory;
import top.lingkang.mm.page.MagicPageInterceptor;
import top.lingkang.mm.transaction.MagicTransactionFactory;
import top.lingkang.mm.utils.MagicUtils;

public class MagicConfiguration
extends Configuration {
    private static final Logger log = LoggerFactory.getLogger(MagicConfiguration.class);
    private final List<String> scanMapperXml = new ArrayList<String>();
    private DataSource dataSource;
    private IdGenerate idGenerate = new DefaultIdGenerate();
    private final List<String> amxCache = new ArrayList<String>();
    private final Set<String> pmxCache = new HashSet<String>();
    private boolean initDbType = false;

    public MagicConfiguration() {
        this(null);
    }

    public MagicConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
        this.setReflectorFactory(new MagicReflectorFactory());
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public MagicConfiguration setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new MagicException("dataSource \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.dataSource = dataSource;
        return this;
    }

    public synchronized MagicConfiguration addMapperXml(String ... mapperXml) {
        if (mapperXml == null) {
            throw new MagicException("addMapperXml \u4e0d\u80fd\u6dfb\u52a0\u7a7a\u503c");
        }
        for (String xml : mapperXml) {
            if (this.amxCache.contains(xml)) continue;
            if (xml.endsWith(".xml") && !xml.endsWith("*.xml")) {
                if (this.pmxCache.contains(xml)) {
                    log.debug("\u65e0\u6cd5\u91cd\u590d\u52a0\u8f7dxml\uff0c\u5df2\u52a0\u8f7d\uff1a{}", (Object)xml);
                    continue;
                }
                InputStream stream = ResourceUtil.getStream((String)xml);
                log.debug("\u52a0\u8f7d mapper xml: {}", (Object)xml);
                XMLMapperBuilder mapperParser = new XMLMapperBuilder(stream, (Configuration)this, xml, this.getSqlFragments());
                try {
                    mapperParser.parse();
                    this.pmxCache.add(xml);
                }
                catch (Exception e) {
                    if (e.getMessage().contains("already contains key")) {
                        log.error("\u5b58\u5728\u91cd\u590d\u7684\u63a5\u53e3\u65b9\u6cd5\uff0c\u5b83\u53ef\u80fd\u4e0e BaseMapper \u4e2d\u7684\u63a5\u53e3\u540d\u79f0\u51b2\u7a81");
                    }
                    throw e;
                }
                IoUtil.close((Closeable)stream);
            } else {
                List<String> list;
                String targetXml = null;
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("");
                if (url == null) {
                    targetXml = xml.endsWith("*") ? xml + ".xml" : (xml.endsWith("/") ? xml + "*.xml" : xml + "/*.xml");
                    list = MagicUtils.scanResource(targetXml);
                    for (String string : list) {
                        this.loadMapperXmlByFile(string, true);
                    }
                } else {
                    targetXml = xml.endsWith("**") ? xml.substring(0, xml.length() - 2) : (xml.endsWith("**.xml") ? xml.substring(0, xml.length() - 6) : (xml.endsWith("*.xml") ? xml.substring(0, xml.length() - 5) : xml));
                    list = FileUtil.loopFiles((String)targetXml);
                    for (File file : list) {
                        this.loadMapperXmlByFile(file.getPath());
                    }
                }
            }
            if (!xml.contains("*")) {
                List list = ResourceUtil.getResources((String)xml);
                for (URL url : list) {
                    String file = url.getFile();
                    this.loadMapperXmlByFile(file, true);
                }
            }
            this.amxCache.add(xml);
        }
        this.scanMapperXml.addAll(Arrays.asList(mapperXml));
        return this;
    }

    private void loadMapperXmlByFile(String filePath) {
        this.loadMapperXmlByFile(filePath, false);
    }

    private void loadMapperXmlByFile(String filePath, boolean isResource) {
        if (!filePath.endsWith(".xml")) {
            return;
        }
        if (!isResource && !FileUtil.isFile((String)filePath)) {
            return;
        }
        if (this.pmxCache.contains(filePath)) {
            log.debug("\u65e0\u6cd5\u91cd\u590d\u52a0\u8f7dxml\uff0c\u5df2\u52a0\u8f7d\uff1a{}", (Object)filePath);
            return;
        }
        BufferedInputStream inputStream = isResource ? MagicConfiguration.class.getClassLoader().getResourceAsStream(filePath) : FileUtil.getInputStream((String)filePath);
        log.debug("\u52a0\u8f7d mapper xml: {}", (Object)filePath);
        XMLMapperBuilder mapperParser = new XMLMapperBuilder((InputStream)inputStream, (Configuration)this, filePath, this.getSqlFragments());
        try {
            mapperParser.parse();
            this.pmxCache.add(filePath);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("already contains key")) {
                log.error("\u5b58\u5728\u91cd\u590d\u7684\u63a5\u53e3\u65b9\u6cd5\uff0c\u5b83\u53ef\u80fd\u4e0e BaseMapper \u51b2\u7a81");
            }
            throw e;
        }
    }

    public List<String> getScanMapperXml() {
        return this.scanMapperXml;
    }

    public IdGenerate getIdGenerate() {
        return this.idGenerate;
    }

    public MagicConfiguration setIdGenerate(IdGenerate idGenerate) {
        this.idGenerate = idGenerate;
        return this;
    }

    public SqlSessionFactory build() {
        Environment environment = new Environment("magic", (TransactionFactory)new MagicTransactionFactory(), this.dataSource);
        this.setEnvironment(environment);
        this.addInterceptor(new MagicPageInterceptor());
        SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build((Configuration)this);
        SqlSessionFactory sessionFactory = (SqlSessionFactory)Proxy.newProxyInstance(MagicConfiguration.class.getClassLoader(), new Class[]{SqlSessionFactory.class}, (InvocationHandler)new SqlSessionFactoryProxy(sqlSessionFactory));
        if (!this.initDbType) {
            SqlSession sqlSession = sessionFactory.openSession();
            try {
                String url = MagicUtils.getDatabaseURL(sqlSession.getConnection(), true);
                this.initDbType = true;
                if (url != null && (url = url.toLowerCase()).contains(":sqlite:")) {
                    sqlSessionFactory.getConfiguration().getTypeHandlerRegistry().register(Date.class, (TypeHandler)new MagicSqliteDateTypeHandler());
                    log.info("\u6ce8\u518csqlite\u7279\u6b8aDate\u7c7b\u578b\u5904\u7406");
                }
            }
            catch (Exception e) {
                log.error("\u5224\u65ad\u6570\u636e\u5e93\u8fde\u63a5\u7c7b\u578b\u9519\u8bef", (Throwable)e);
            }
        }
        return sessionFactory;
    }
}

