/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.orm;

import java.util.Collection;
import java.util.Map;
import top.lingkang.mm.error.MagicException;
import top.lingkang.mm.orm.Condition;
import top.lingkang.mm.orm.ConditionHandler;

class QueryUtils {
    QueryUtils() {
    }

    public static void initHandler(Map<Condition, ConditionHandler> handlers) {
        handlers.put(Condition.symbol, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(" ").append(condition.getSymbol()).append(" ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue());
        });
        handlers.put(Condition.eq, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append("= ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue());
        });
        handlers.put(Condition.ne, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append("<> ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue());
        });
        handlers.put(Condition.gt, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append("> ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue());
        });
        handlers.put(Condition.ge, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(">= ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue());
        });
        handlers.put(Condition.lt, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append("< ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue());
        });
        handlers.put(Condition.le, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append("<= ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue());
        });
        handlers.put(Condition.like, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(" like ");
            query.addQueryParam(sql, p);
            query.param.put(p, "%" + condition.getValue() + "%");
        });
        handlers.put(Condition.notLike, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(" not like ");
            query.addQueryParam(sql, p);
            query.param.put(p, "%" + condition.getValue() + "%");
        });
        handlers.put(Condition.likeLeft, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(" like ");
            query.addQueryParam(sql, p);
            query.param.put(p, "%" + condition.getValue());
        });
        handlers.put(Condition.likeRight, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(" like ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue() + "%");
        });
        handlers.put(Condition.notLikeLeft, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(" not like ");
            query.addQueryParam(sql, p);
            query.param.put(p, "%" + condition.getValue());
        });
        handlers.put(Condition.notLikeRight, (sql, query, condition, p) -> {
            sql.append(condition.getColumn()).append(" not like ");
            query.addQueryParam(sql, p);
            query.param.put(p, condition.getValue() + "%");
        });
        handlers.put(Condition.isNull, (sql, query, condition, p) -> sql.append(condition.getColumn()).append(" is null"));
        handlers.put(Condition.isNotNull, (sql, query, condition, p) -> sql.append(condition.getColumn()).append(" is not null"));
        handlers.put(Condition.in, (sql, query, condition, p) -> {
            if (condition.getValue() != null) {
                Collection collection = (Collection)condition.getValue();
                if (collection.isEmpty()) {
                    throw new MagicException("\u67e5\u8be2\u6761\u4ef6: in \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                sql.append(condition.getColumn()).append(" in (");
                int j = 1;
                for (Object o : collection) {
                    String name = p + "_" + j;
                    query.addQueryParam(sql, name);
                    query.param.put(name, o);
                    if (j < collection.size()) {
                        sql.append(",");
                    }
                    ++j;
                }
            } else {
                throw new MagicException("in \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            sql.append(")");
        });
        handlers.put(Condition.notIn, (sql, query, condition, p) -> {
            if (condition.getValue() != null) {
                Collection collection = (Collection)condition.getValue();
                if (collection.isEmpty()) {
                    throw new MagicException("\u67e5\u8be2\u6761\u4ef6: notIn \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                sql.append(condition.getColumn()).append(" not in (");
                int j = 1;
                for (Object o : collection) {
                    String name = p + "_" + j;
                    query.addQueryParam(sql, name);
                    query.param.put(name, o);
                    if (j < collection.size()) {
                        sql.append(",");
                    }
                    ++j;
                }
            } else {
                throw new MagicException("in \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            sql.append(")");
        });
    }
}

