/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.mm.utils;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class CommonUtils {
    private static final Snowflake snowflake = IdUtil.getSnowflake((long)1L, (long)1L);
    private static final SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyyMM");
    private static final Random random = new Random();
    private static final String digits = "0123456789abcdefghijklmnopqrstuvwxyz";

    public static String getCurrentYyyyMM() {
        return yyyyMM.format(new Date());
    }

    public static String randomNumber(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    public static String randomLetter(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append((char)(97 + random.nextInt(26)));
        }
        return sb.toString();
    }

    public static long nextId() {
        return snowflake.nextId();
    }

    public static String nextIdStr() {
        return snowflake.nextIdStr();
    }

    public static String nextId36() {
        return CommonUtils.to36(CommonUtils.nextId());
    }

    public static String to36(long number) {
        StringBuilder result = new StringBuilder();
        while (number > 0L) {
            int remainder = (int)(number % 36L);
            result.insert(0, digits.charAt(remainder));
            number /= 36L;
        }
        return result.toString();
    }

    public static String removeSpace(String str) {
        while (str.contains(" ")) {
            str = str.replace(" ", "");
        }
        return str;
    }

    public static String toSha1(String input) {
        try {
            MessageDigest sha1Digest = MessageDigest.getInstance("SHA-1");
            byte[] hashedBytes = sha1Digest.digest(input.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : hashedBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 not supported", e);
        }
    }

    public static int compareVersion(String version1, String version2) {
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }

    public static boolean isWindowSystem() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }
}

